LD         := mipsel-unknown-elf-ld
CC         := mipsel-unknown-elf-gcc
AS         := mipsel-unknown-elf-as
DU         := mipsel-unknown-elf-objdump
AR         := mipsel-unknown-elf-ar
RM         := rm -rf
ECHO       := @echo
MKDIR      := mkdir
HEXDUMP    := hexdump
DOXYGEN    := doxygen
SED        := sed
SHELL      := bash

CFLAGS     := -Wall                        \
              -mno-gpopt                   \
              -ffreestanding               \
              -fomit-frame-pointer         \
              -march=mips32                \
              -Og                          \
              -ggdb                        \
#             -msoft-float                 \
#             -Werror                      \
#             -Wno-unused-but-set-variable \
#             -std=gnu99                   \
#             -mlong-calls                 \

BUILD_DIR  := build

UTILS_PATH := ../../../../../softs
MDLS_PATH  := ../../../..

INCLUDE    := -I$(UTILS_PATH)/drivers/ \
              -I$(UTILS_PATH)/libs/ \
              -I$(UTILS_PATH)/mach/	\
              -I$(MDLS_PATH)/vci_xicu/include \
              -I$(MDLS_PATH)/dspin_router/include \
			  -I.

VPATH      := $(UTILS_PATH)/drivers/ \
              $(UTILS_PATH)/libs/ \
              $(UTILS_PATH)/mach/

# ============================================================================
# Debug compilation flags
# ============================================================================

DEBUG_DEFS ?=

DEBUG ?= 1
ifeq ($(DEBUG),0)
    DEBUG_DEFS += -DNDEBUG # deactivate assertions
endif

# ============================================================================
# Compilation flags
# ============================================================================

DEFS := $(DEBUG_DEFS)

# =============================================================================
# Implicit makefile rules
# =============================================================================

$(BUILD_DIR)/%.o: %.c
	$(CC) $(DEFS) $(CFLAGS) $(INCLUDE) -c -o $@ $<
	$(DU) -D $@ > $@.txt

$(BUILD_DIR)/%.o: %.S
	$(CC) $(DEFS) $(CFLAGS) $(INCLUDE) -c -o $@ $<
	$(DU) -D $@ > $@.txt

