#!/usr/bin/env sh
# @author	Cesar Armando Fuguet Tortolero
# @date		24 May, 2015
# @brief
file=$1
awk '
BEGIN {
	total=0
	total_load=0
	targets=0
}

#   Parse the number of received packets
/unicast received packets +=/ {
	packets=$6
}

#   Parse the unicast latency
/unicast latency +=/ {
	latency=$5;
	total+=latency;
	if (latency > 0) {
		targets++;
	}
}

/accepted load +=/ {
	total_load+=$5;
}

#   Validate the file
END {
	print "mean latency=" total/targets
	print "mean load=" total_load/targets
	exit 0;
}' $file
if [[ $? == 1 ]]; then exit 1; fi

