#include "stdio.h"
#include "cpu.h"
#include "hard_config.h"
#include "io.h"
#include "simhelper.h"
#include "cpu_registers.h"
#include "xcu.h"
#include "soclib/dspin_router_config.h"
#include "assert.h"

void exception_handler()
{
    printf("exception_handler(): failure / pid %d\n", cpu_procid());
    simh_stop_simulation();
}

void main(void)
{
    printf("main(): pid %d\n", cpu_procid());

    /* set the watchdog timer threshold to detect an error during the
     * reconfiguration of the NoC */
    cpu_set_wdt_max(5000);

    /* configure the routers around the blackhole (1, 1) to define a cycle-free
     * contour */
    const int RECOVERY = 1;
    uint32_t val;

    printf("router(0, 2): configuring as NW\n");
    val = (REQ_SOUTH << 5) | (RECOVERY << 4) | NW_OF_X;
    xcu_set_register(0, 2, XICU_CFG_REG, 0, val);     /* configure NW */

    printf("router(0, 1): configuring as W\n");
    val = (REQ_LOCAL << 5) | (RECOVERY << 4) | W_OF_X;
    xcu_set_register(0, 1, XICU_CFG_REG, 0, val);     /* configure W */

    printf("router(0, 0): configuring as SW\n");
    val = (REQ_NORTH << 5) | (RECOVERY << 4) | SW_OF_X;
    xcu_set_register(0, 0, XICU_CFG_REG, 0, val);     /* configure SW */

    printf("router(1, 2): configuring as N\n");
    val = (REQ_WEST << 5) | (RECOVERY << 4) | N_OF_X;
    xcu_set_register(1, 2, XICU_CFG_REG, 0, val);     /* configure N */

    printf("router(2, 2): configuring as NE\n");
    val = (REQ_WEST << 5) | (RECOVERY << 4) | NE_OF_X;
    xcu_set_register(2, 2, XICU_CFG_REG, 0, val);     /* configure NE */

    printf("router(2, 1): configuring as E\n");
    val = (REQ_SOUTH << 5) | (RECOVERY << 4) | E_OF_X;
    xcu_set_register(2, 1, XICU_CFG_REG, 0, val);     /* configure E */

    printf("router(2, 0): configuring as SE\n");
    val = (REQ_WEST << 5) | (RECOVERY << 4) | SE_OF_X;
    xcu_set_register(2, 0, XICU_CFG_REG, 0, val);     /* configure SE */

    printf("router(1, 0): configuring as S\n");
    val = (REQ_WEST << 5) | (RECOVERY << 4) | S_OF_X;
    xcu_set_register(1, 0, XICU_CFG_REG, 0, val);     /* configure S */

    assert((xcu_get_register(0, 2, XICU_CFG_REG, 0) & 0xF) == NW_OF_X);
    assert((xcu_get_register(0, 1, XICU_CFG_REG, 0) & 0xF) == W_OF_X);
    assert((xcu_get_register(0, 0, XICU_CFG_REG, 0) & 0xF) == SW_OF_X);
    assert((xcu_get_register(1, 2, XICU_CFG_REG, 0) & 0xF) == N_OF_X);
    assert((xcu_get_register(2, 2, XICU_CFG_REG, 0) & 0xF) == NE_OF_X);
    assert((xcu_get_register(2, 1, XICU_CFG_REG, 0) & 0xF) == E_OF_X);
    assert((xcu_get_register(2, 0, XICU_CFG_REG, 0) & 0xF) == SE_OF_X);
    assert((xcu_get_register(1, 0, XICU_CFG_REG, 0) & 0xF) == S_OF_X);

    /* Test the recovered segment that has been migrated to the EAST cluster */
    ioread32(CLUSTER_BASE(1, 1) | SEG_RAM_BASE);

    printf("main(): success\n");
    simh_stop_simulation();
}

/*
 * vim: tabstop=4 : softtabstop=4 : shiftwidth=4 : expandtab
 */
