/**
 * File   : reset.S
 * Author : Cesar FUGUET <cesar.fuguet-tortolero@lip6.fr>
 * Date   : 16 October 2014
 */

#include "hard_config.h"
#include "cpu_registers.h"

    .section .reset,"ax",@progbits

    .extern seg_stack_base
    .extern seg_kcode_base
    .extern main

    .globl  reset
    .ent    reset
    .align  2

#define P_MASK ((1<<P_WIDTH)-1)
#define Y_MASK ((1<<Y_WIDTH)-1)

#define XCU_REG(func, idx) ((((func)<<5)|(idx)) << 2)
#define XCU_CFG_REG 17
#define XCU_BARRIER 5

#define MEMC_REG(func,idx) (((func<<7)|idx) << 2)
#define MEMC_CONFIG 0
#define MEMC_SCRATCHPAD 4

reset:
    .set noreorder

    /*
     * SR register initialization
     * - Disable interrupts
     * - Keep the Bootstrap Exception Vector (BEV) bit set
     */
    li     k0,  0x00400000
    mtc0   k0,  CP0_STATUS

    /*
     * Get processor ID
     */
    mfc0   k0,  CP0_PROCID
    andi   k0,  k0,  0xFFF             /* k0 <= proc_xyl                     */

    /*
     * Release local gateway hardware barrier
     */
    la     k1,     SEG_XCU_BASE        /* k1 <= ICU base address             */
    li     t0,     XCU_REG(XCU_CFG_REG, XCU_BARRIER)
    or     k1,     k1,     t0          /* k1 <= &XICU[CFG_REG][BARRIER]      */
    li     t0,     0xFFFFFFFF
    sw     t0,     0(k1)

    /*
     * Disable the scratchpad mode on the local memory cache
     */
    la     k1,     SEG_MMC_BASE        /* k1 <= MMC base address             */
    li     t0,     MEMC_REG(MEMC_CONFIG, MEMC_SCRATCHPAD)
    or     k1,     k1,     t0          /* k1 <= &MEMC[CONFIG][SCRATCHPAD]    */
    sw     zero,   0(k1)

    /* Only the processor 0 continues the execution                          */
    beqz   k0,  1f
    nop
    wait

1:  /* processor 0 initializes stack pointer (16K) */
    la     sp,  _stack
    addiu  sp,  sp,  (1<<14)           /* sp <= _stack + 16K                 */

    /* jumps to main in kernel mode */
    jal    main
    nop

    j      exit
    nop

    .set reorder
    .end reset



.org 0x380

reset_exception_handler:
    mtc2   $0,  MMU_DATA_PADDR_EXT
    j exception_handler



    .section .data

/*
 * Stack segment definition
 */
_stack:
    .space (1<<14)                     /* 16 Kbytes                      */

/*
 * vim: tabstop=4 : softtabstop=4 : shiftwidth=4 : expandtab
 */
