#!/usr/bin/env sh
LOGDIR=logs
COMMON="-X 5 -Y 5 -B 0 -N 10000 -P 0"
MEANFILE=unicast_mean_latency.txt
MAXLOAD=550
SCRIPTPATH=$(dirname $0)

# compile the platform
make
if [[ ! -f simul.x ]]; then exit 1; fi;

rm -f $MEANFILE

mkdir -p $LOGDIR
for (( load = 25; load <= $MAXLOAD; load += 25 )); do
	LOGFILE=$LOGDIR/$(echo latency_unicast_all'_'$load);
	ARGS="$COMMON -L $load";
	echo "./simul.x $ARGS ($LOGFILE)" | tee -a $MEANFILE
	./simul.x $ARGS > $LOGFILE 2>/dev/null;
	$SCRIPTPATH/unicast_latency.sh $LOGFILE >> $MEANFILE
done

for (( x = 0; x < 5; x++ )); do
	for (( y = 0; y < 5; y++ )); do
		for (( load = 25; load <= $MAXLOAD; load += 25 )); do
			LOGFILE=$LOGDIR/$(echo latency_unicast_all'_'$x'_'$y'_'$load);
			ARGS="$COMMON -L $load -FX $x -FY $y";
			echo "./simul.x $ARGS ($LOGFILE)" | tee -a $MEANFILE
			./simul.x $ARGS > $LOGFILE 2>/dev/null;
			$SCRIPTPATH/unicast_latency.sh $LOGFILE >> $MEANFILE
		done;
	done;
done;
