#!/bin/bash

make mkconfig

SOFT=build/soft.elf
make $SOFT

# batch mode => no xterm or frame buffer windows
export SOCLIB_TTY=FILES
export SOCLIB_FB=HEADLESS
#export SOCLIB_GDB=
export DISTRIBUTED_BOOT=1
PLATFORM=../../../../../platforms/tsar_generic_iob
SIMULATOR=$PLATFORM/simul.x
$SIMULATOR -DSOFT $SOFT \
           -DISK /dev/null \
           -FAULTY_ROUTER 0 1 1 \
           -NCYCLES 20000 > output/log 2>&1
#          -PROCID 0 \
#          -MEMCID 0x1 \
#          -DEBUG 3000 \

soclib-cleanup-terms &> /dev/null
mv term0 output/term
grep -q "success" output/term
if [ $? == 0 ];
    then echo $(basename $PWD) ": Success";
    else echo $(basename $PWD) ": Failure";
fi;
