/**********************************************************
  File   : ldscript
  Author : Cesar Fuguet
  Date   : June 2011
**********************************************************/

/* Definition of the base address for code segment */

seg_code_base = 0xBFC00000;
seg_data_base = 0x00001000;

/* Grouping sections into segments */

ENTRY(reset)

SECTIONS
{
    . = seg_code_base;
    .text :
    {
        *(.reset)
        *(.text)
        *(.text.*)
        *(.rodata)
        *(.rodata.*)
    }

    . = seg_data_base;
    .bss ALIGN(0x4) (NOLOAD) :
    {
        *(.data)
        *(.bss)
    }
}

/*
 * vim: tabstop=4 : softtabstop=4 : shiftwidth=4 : expandtab
 */
