/**
 * \file   dspin_memcache_cc_test.cpp
 * \date   October 10, 2014
 * \author Cesar Fuguet <cesar.fuguet-tortolero@lip6.fr>
 */
#include "dspin_memcache_cc_test.h"
#include <cstdlib>

#define tmpl(x) template<size_t M2P_WIDTH, size_t P2M_WIDTH> x \
    DspinMemcacheCcTest<M2P_WIDTH, P2M_WIDTH>

namespace soclib { namespace caba {

tmpl(/**/)::DspinMemcacheCcTest(sc_module_name name) :
    BaseModule(name),
    m_srcid(0),
    r_gen_test_fsm("r_gen_test_fsm"),
    r_sign("r_sign")
{
    SC_METHOD(transition);
    dont_initialize();
    sensitive << p_clk.pos();

    SC_METHOD(genMoore);
    dont_initialize();
    sensitive << p_clk.neg();
}

tmpl(/**/)::~DspinMemcacheCcTest()
{

}

tmpl(void)::transition()
{
    if (!p_resetn.read()) {
        r_gen_test_fsm = P2M_HEADER;
        r_sign = 1;
        return;
    }

    switch(r_gen_test_fsm.read()) {
        case P2M_HEADER:
            if (!p_dspin_p2m.read.read()) break;

            assert(!p_dspin_m2p.write.read());
            assert(!p_dspin_clack.write.read());

            r_gen_test_fsm = P2M_SIGNATURE;

#if SOCLIB_MODULE_DEBUG
            std::cout << this->name() << ":P2M_HEADER" << std::endl;
#endif
            break;

        case P2M_SIGNATURE:
            if (!p_dspin_p2m.read.read()) break;

            assert(!p_dspin_m2p.write.read());
            assert(!p_dspin_clack.write.read());

            r_gen_test_fsm = WAIT_M2P_AND_CLACK;

#if SOCLIB_MODULE_DEBUG
            std::cout << this->name() << ":P2M_SIGNATURE" << std::endl;
#endif
            break;

        case WAIT_M2P_AND_CLACK:
        {
            if (!p_dspin_m2p.write.read() || !p_dspin_clack.write.read()) break;

            uint64_t m2p_dest =
                FlitParam::dspin_get(p_dspin_m2p.data.read(),
                                     FlitParam::TEST_M2P_DEST);
            uint64_t m2p_test =
                FlitParam::dspin_get(p_dspin_m2p.data.read(),
                                     FlitParam::TEST_M2P_TEST);
            uint64_t clack_dest =
                FlitParam::dspin_get(p_dspin_clack.data.read(),
                                     FlitParam::TEST_CLACK_DEST);
            uint64_t clack_test =
                FlitParam::dspin_get(p_dspin_clack.data.read(),
                                     FlitParam::TEST_CLACK_TEST);

            assert(!p_dspin_m2p.eop.read());
            assert(!p_dspin_clack.eop.read());
            assert((uint32_t)m2p_dest == m_srcid);
            assert((uint32_t)clack_dest == m_srcid);
            assert(m2p_test);
            assert(clack_test);

            r_gen_test_fsm = CHECK_SIGNATURE;

#if SOCLIB_MODULE_DEBUG
            std::cout << this->name() << ":WAIT_M2P_AND_CLACK" << std::endl;
#endif
            break;
        }

        case CHECK_SIGNATURE:
        {
            uint64_t m2p_sign =
                FlitParam::dspin_get(p_dspin_m2p.data.read(),
                                     FlitParam::TEST_M2P_SIGNATURE);
            uint64_t clack_sign =
                FlitParam::dspin_get(p_dspin_clack.data.read(),
                                     FlitParam::TEST_CLACK_SIGNATURE);

            assert((uint32_t)(m2p_sign & ((1ULL << 32) - 1)) ==
                    r_sign.read());
            assert((uint32_t)(m2p_sign >> 32) ==
                   (r_sign.read() & ((1 << 7) - 1)));
            assert((uint32_t)(clack_sign & ((1ULL << 32) - 1)) ==
                    r_sign.read());
            assert((uint32_t)(clack_sign >> 32) ==
                   (r_sign.read() & ((1 << 7) - 1)));

            if ((uint32_t)(m2p_sign & ((1ULL << 32) - 1)) == (1UL << 31)) {
                std::cout << this->name() << ": success" << std::endl;
                exit(EXIT_SUCCESS);
            }

            r_sign = r_sign.read() << 1;
            r_gen_test_fsm = P2M_HEADER;

#if SOCLIB_MODULE_DEBUG
            std::cout << this->name() << ":CHECK_SIGNATURE" << std::endl;
#endif
            break;
        }
    }
}

tmpl(void)::genMoore()
{
    p_dspin_p2m.write = false;
    p_dspin_p2m.data = 0;
    p_dspin_p2m.eop = 0;
    p_dspin_m2p.read = 0;
    p_dspin_clack.read = 0;

    switch(r_gen_test_fsm.read()) {
        case P2M_HEADER:
        {
            uint64_t flit = 0;
            FlitParam::dspin_set(flit, 0, FlitParam::TEST_P2M_DEST);
            FlitParam::dspin_set(flit, m_srcid, FlitParam::TEST_P2M_SRCID);
            FlitParam::dspin_set(flit, 1, FlitParam::TEST_P2M_TEST);
            FlitParam::dspin_set(flit, FlitParam::TYPE_TEST,
                                 FlitParam::P2M_TYPE);
            p_dspin_p2m.data = flit;
            p_dspin_p2m.write = true;
            break;
        }

        case P2M_SIGNATURE:
        {
            uint64_t flit = 0;
            FlitParam::dspin_set(flit, r_sign.read(),
                                 FlitParam::TEST_P2M_SIGNATURE);
            p_dspin_p2m.eop = true;
            p_dspin_p2m.data = flit;
            p_dspin_p2m.write = true;
            break;
        }

        case WAIT_M2P_AND_CLACK:
            p_dspin_m2p.read = true;
            p_dspin_clack.read = true;
            break;

        case CHECK_SIGNATURE:
            p_dspin_m2p.read = true;
            p_dspin_clack.read = true;
            break;
    }
}

}                               /* namespace caba */
}                               /* namespace soclib */

/*
 * vim: ts=4 : sw=4 : sts=4 : et
 */
