#!/usr/bin/env awk -f
###############################################################################
# @author : Cesar Armando Fuguet Tortolero
# @date   : jul 2015
# @desc   : parse the output of the broadcast synthetic platform to
#           get statistics
###############################################################################
BEGIN {
    FS="[ \t]*"
    cluster=0

    # the name of the output file can be given with awk arguments
    # '-v statsname=<name>'
    if (!statsname) {
	statsname = "broadcast_stats.dat"
    }
}

/DSPIN_GENERATOR/ {
    name[cluster]=$2
    FS=" *= *"
}

/[\t ]*-[\t ]*broadcast sent packets/ {
    sent[cluster]=$2
}

/[\t ]*-[\t ]*fifo max fill status/ {
    fill[cluster]=$2
}

/[\t ]*-[\t ]*broadcast latency/ {
    latency[cluster]=$2
}

/[\t ]*-[\t ]*broadcast max latency/ {
    max[cluster]=$2
    cluster++
    FS="[ \t]*"
}

END {
    print "broadcast latency" > statsname
    print "name\t\t\tmean\t\tmax\t\tfill\t\tsent" >> statsname
    for (i = 0; i < cluster; i++) {
	print name[i] "\t\t" latency[i] "\t\t" max[i] "\t\t" \
	    fill[i] "\t\t" sent[i] >> statsname
    }
}
