/* -*- c++ -*-
 *
 * SOCLIB_LGPL_HEADER_BEGIN
 *
 * This file is part of SoCLib, GNU LGPLv2.1.
 *
 * SoCLib is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; version 2.1 of the License.
 *
 * SoCLib is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with SoCLib; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 * SOCLIB_LGPL_HEADER_END
 *
 * Copyright (c) UPMC, Lip6, Asim
 *         Cesar Fuguet <cesar.fuguet-tortolero@lip6.fr>, 2014
 *
 */
#ifndef SOCLIB_VCI_ROUTER_CONFIG_H
#define SOCLIB_VCI_ROUTER_CONFIG_H

#include <systemc>
#include "caba_base_module.h"
#include "mapping_table.h"
#include "int_tab.h"
#include "vci_target.h"

namespace soclib {
namespace caba {

using namespace sc_core;
using namespace soclib::common;

template<typename vci_param>
class VciTsarConfig : public soclib::caba::BaseModule
{
    typedef typename vci_param::fast_addr_t vci_addr_t;
    typedef typename vci_param::fast_data_t vci_data_t;
    typedef typename vci_param::srcid_t vci_srcid_t;
    typedef typename vci_param::trdid_t vci_trdid_t;
    typedef typename vci_param::pktid_t vci_pktid_t;

  public:

    enum fsm_state_e
    {
        IDLE,
        RSP_WRITE,
        RSP_READ,
        RSP_ERROR,
    };

    // Ports
    sc_core::sc_in<bool> p_clk;
    sc_core::sc_in<bool> p_resetn;
    sc_core::sc_out<int> p_blackhole_pos;
    VciTarget<vci_param> p_vci;

    VciTsarConfig(sc_module_name name,
                  const IntTab &index,
                  const MappingTable &mt);

    ~VciTsarConfig();


  private:

    // Registers
    sc_signal<int> r_fsm_state;

    sc_signal<vci_data_t> r_rdata;
    sc_signal<vci_srcid_t> r_srcid;
    sc_signal<vci_trdid_t> r_trdid;
    sc_signal<vci_pktid_t> r_pktid;

    sc_signal<int> r_blackhole_pos;

    std::list<soclib::common::Segment> m_seglist;

    void transition();
    void genMoore();

protected:

    SC_HAS_PROCESS(VciTsarConfig);

public:

    void print_trace();
};

}}

#endif                                 /* SOCLIB_VCI_ROUTER_CONFIG_H */

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

