#!/bin/bash

make mkconfig

SOFT=build/soft.elf
make $SOFT

# batch mode => no xterm or frame buffer windows
export SOCLIB_TTY=FILES
export SOCLIB_FB=HEADLESS
#export SOCLIB_GDB=
export DISTRIBUTED_BOOT=1
PLATFORM=../../../../../platforms/tsar_generic_iob
SIMULATOR=$PLATFORM/simul.x
$SIMULATOR -DSOFT $SOFT -DISK /dev/null -FAULTY_ROUTER 0 1 1 2> /dev/null >> output/log
soclib-cleanup-terms &> /dev/null
mv term0 output/term
grep -q "success" output/term
if [ $? == 0 ];
	then echo $(basename $PWD) ": Success";
	else echo $(basename $PWD) ": Failure";
fi;
