#include "stdio.h"
#include "cpu.h"
#include "hard_config.h"
#include "io.h"
#include "simhelper.h"
#include "cpu_registers.h"
#include "xcu.h"
#include "soclib/dspin_router_config.h"
#include "assert.h"

void exception_handler()
{
    printf("exception_handler(): failure / pid %d\n", cpu_procid());
    simh_stop_simulation();
}

void main(void)
{
    printf("main(): pid %d\n", cpu_procid());

    /* set the watchdog timer threshold to detect an error during the
     * reconfiguration of the NoC */
    cpu_set_wdt_max(5000);

    /* configure the routers around the blackhole (1, 1) to define a cycle-free
     * contour */
    uint32_t val;

    printf("router(0, 2): configuring as NW\n");
    assert(xcu_get_register(0, 2, XICU_CFG_REG, 0) == BH_NONE);
    val = (REQ_SOUTH << 4) | BH_NW;
    xcu_set_register(0, 2, XICU_CFG_REG, 0, val);     /* configure NW */

    printf("router(0, 1): configuring as W\n");
    assert(xcu_get_register(0, 1, XICU_CFG_REG, 0) == BH_NONE);
    val = (REQ_LOCAL << 4) | BH_W;
    xcu_set_register(0, 1, XICU_CFG_REG, 0, val);     /* configure W */

    printf("router(0, 0): configuring as SW\n");
    assert(xcu_get_register(0, 0, XICU_CFG_REG, 0) == BH_NONE);
    val = (REQ_NORTH << 4) | BH_SW;
    xcu_set_register(0, 0, XICU_CFG_REG, 0, val);     /* configure SW */

    printf("router(1, 2): configuring as N\n");
    assert(xcu_get_register(1, 2, XICU_CFG_REG, 0) == BH_NONE);
    val = (REQ_WEST << 4) | BH_N;
    xcu_set_register(1, 2, XICU_CFG_REG, 0, val);     /* configure N */

    printf("router(2, 2): configuring as NE\n");
    assert(xcu_get_register(2, 2, XICU_CFG_REG, 0) == BH_NONE);
    val = (REQ_WEST << 4) | BH_NE;
    xcu_set_register(2, 2, XICU_CFG_REG, 0, val);     /* configure NE */

    printf("router(2, 1): configuring as E\n");
    assert(xcu_get_register(2, 1, XICU_CFG_REG, 0) == BH_NONE);
    val = (REQ_SOUTH << 4) | BH_E;
    xcu_set_register(2, 1, XICU_CFG_REG, 0, val);     /* configure E */

    printf("router(2, 0): configuring as SE\n");
    assert(xcu_get_register(2, 0, XICU_CFG_REG, 0) == BH_NONE);
    val = (REQ_WEST << 4) | BH_SE;
    xcu_set_register(2, 0, XICU_CFG_REG, 0, val);     /* configure SE */

    printf("router(1, 0): configuring as S\n");
    assert(xcu_get_register(1, 0, XICU_CFG_REG, 0) == BH_NONE);
    val = (REQ_WEST << 4) | BH_S;
    xcu_set_register(1, 0, XICU_CFG_REG, 0, val);     /* configure S */

    assert((xcu_get_register(0, 2, XICU_CFG_REG, 0) & 0xF) == BH_NW);
    assert((xcu_get_register(0, 1, XICU_CFG_REG, 0) & 0xF) == BH_W);
    assert((xcu_get_register(0, 0, XICU_CFG_REG, 0) & 0xF) == BH_SW);
    assert((xcu_get_register(1, 2, XICU_CFG_REG, 0) & 0xF) == BH_N);
    assert((xcu_get_register(2, 2, XICU_CFG_REG, 0) & 0xF) == BH_NE);
    assert((xcu_get_register(2, 1, XICU_CFG_REG, 0) & 0xF) == BH_E);
    assert((xcu_get_register(2, 0, XICU_CFG_REG, 0) & 0xF) == BH_SE);
    assert((xcu_get_register(1, 0, XICU_CFG_REG, 0) & 0xF) == BH_S);

    /* Test the recovered segment that has been migrated to the EAST cluster */
    ioread32(CLUSTER_BASE(1, 1) | SEG_RAM_BASE);

    printf("main(): success\n");
    simh_stop_simulation();
}

/*
 * vim: tabstop=4 : softtabstop=4 : shiftwidth=4 : expandtab
 */
