/**
 * File   : reset.S
 * Author : Cesar FUGUET <cesar.fuguet-tortolero@lip6.fr>
 * Date   : 16 October 2014
 */

#include "hard_config.h"
#include "cpu_registers.h"

    .section .reset,"ax",@progbits

    .extern seg_stack_base
    .extern seg_kcode_base
    .extern main

    .globl  reset
    .ent    reset
    .align  2

#define P_MASK ((1<<P_WIDTH)-1)
#define Y_MASK ((1<<Y_WIDTH)-1)

reset:
    .set noreorder

    /* 
     * SR register initialization
     * - Disable interrupts
     * - Keep the Bootstrap Exception Vector (BEV) bit set
     */
    li     k0,  0x00400000
    mtc0   k0,  CP0_STATUS

    /* 
     * All processors compute:
     *   cid = (x * Y_SIZE) + y
     *   pid = (cid * NB_PROCS_MAX) + lpid
     */
    mfc0   k0,  CP0_PROCID
    andi   k0,  k0,  0xFFF             /* k0 <= proc_xyl                 */
    andi   t1,  k0,  P_MASK            /* t1 <= lpid                     */
    srl    t2,  k0,  P_WIDTH           /* t2 <= cluster_xy               */
    srl    t3,  t2,  Y_WIDTH           /* t3 <= x coordinate             */
    andi   t4,  t2,  Y_MASK            /* t4 <= y coordinate             */

    li     t6,  Y_SIZE                 /* t6 <= Y_SIZE                   */
    multu  t3,  t6
    mflo   t5
    addu   k0,  t5,  t4                /* k0 <= cid                      */

    li     t7,  NB_PROCS_MAX
    multu  t5,  t7
    mflo   t0
    addu   k1,  t0,  t1                /* k1 <= pid                      */

    /* each proc initializes stack pointer (16K per processor) */
    addi   t0,  k1,  1                 /* t0 <= (pid + 1)                */
    sll    t0,  t0,  14                /* t0 <= (pid + 1) * 16K          */
    la     sp,  _stack
    addu   sp,  sp,  t0                /* sp <= _stack[pid]              */

    /* jumps to main in kernel mode */
    jal    main
    nop

    j      exit
    nop

    .set reorder
    .end reset



.org 0x380

reset_exception_handler:
    mtc2   $0,  MMU_DATA_PADDR_EXT 
    j exception_handler



    .section .data

/*
 * Stack segment definition
 * It contains the stacks of all processors, thus, if each one is using a
 * 16 Kbytes stack and the segment is 512 Kbytes length then the max number
 * of processors supported is 32
 */
_stack:
    .space (1<<19)                     /* 512 Kbytes                     */

/*
 * vim: tabstop=4 : softtabstop=4 : shiftwidth=4 : expandtab
 */
