#!/usr/bin/env sh
# @author	Cesar Armando Fuguet Tortolero
# @date		24 May, 2015
# @brief	This script validates that a broadcast transaction reaches once
#			and only once every non-faulty router in the platform.
file=$1
awk '
BEGIN {
	sent=0
	total=0
	targets=0
}
#   Parse coordinates of routers
/DSPIN_GENERATOR/ {
	regex="\\[[0-9]+\\]\\[";
	if (match($2,regex)) {
		x=substr($2,RSTART+1,RLENGTH-3);
	}
	regex="\\]\\[[0-9]+\\]";
	if (match($2,regex)) {
		y=substr($2,RSTART+2,RLENGTH-3);
	}
}

#   Parse the number of sent broadcast packets
/broadcast sent packets += +/ {
	if ($6 != 0) {
		sent=$6;
	}
}

#   Parse the number of received broadcast packets
/broadcast received packets +=/ {
	packets=$6
}

#   Parse the broadcast latency
/broadcast latency +=/ {
	latency=$5;
	total+=latency;
	if (latency > 0) {
		targets++;
	}
}

#   Validate the file
END {
	print "mean latency=" total/targets
	exit 0;
}' $file
if [[ $? == 1 ]]; then exit 1; fi

