#!/usr/bin/python
# @date   25 August, 2014
# @author cfuguet <cesar.fuguet-tortolero@lip6.fr>

import os
import sys
import subprocess

nprocs = 4

configs = []
configs.append([2 ,2 ])
configs.append([4 ,4 ])
configs.append([8 ,8 ])
configs.append([16,16])

# repeat while configurations is not empty
for x,y in configs:
    confdir = os.getcwd() + "/conf/config_{}c/".format(x*y)

    # 1. generate configuration and ouput directories
    try:
        os.makedirs(confdir + "config", 0755)
    except OSError:
        # directory already exists => do nothing
        pass

    # 2. generate hard_config.h and fault_config.h files
    returncode = subprocess.call(["scripts/genmap",
        "--x=" + str(x),
        "--y=" + str(y),
        "--p=" + str(nprocs),
        "--arch=" + os.getcwd(),
        "--path=" + confdir + "config"
        ])
    if returncode != 0:
        print "Error during genmap execution"
        sys.exit(1)

    # 3. compile simulator executable
    if os.path.exists("hard_config.h"): os.unlink("hard_config.h")
    os.symlink(confdir + "config/hard_config.h", "hard_config.h")
    subprocess.call("make")

    # 4. compile distributed boot executable
    dst = confdir + "config/boot_config.h"
    if not os.path.exists(dst):
        os.symlink(os.getcwd() + "/soft/config/boot_config.h", dst)
    dst = confdir + "config/fault_config.h"
    if not os.path.exists(dst):
        os.symlink(os.getcwd() + "/soft/config/fault_config.h", dst)
    subprocess.call(["make",
        "-C", "soft",
        "CONFDIR=" + confdir
        ])

    # 5. execute simulator
    os.environ["DISTRIBUTED_BOOT"] = "1"
    os.environ["SOCLIB_TTY"] = "FILES"
    with open(confdir + "log", "w") as log_file:
        subprocess.call(["./simul.x",
            "-SOFT"   , "soft/build/soft.elf",
            "-DISK"   , "/dev/null",
            "-NCYCLES", "500000"],
            stdout=log_file,
            stderr=log_file,
            )

    # 6. move simulation terminal output into the target config dir
    os.rename("term0", confdir + "term")

# end repeat

# vim: tabstop=4 : softtabstop=4 : shiftwidth=4 : expandtab
