import os
import sys

def parse_ffstend(configs, confpath, outpath):
    # write header
    ffst_end = open(outpath, "w")
    ffst_end.writelines([
        "#  ffst end (cycles)\n",
        "#  clusters cycles\n",
        "\n"])

    # repeat while configurations is not empty
    for x,y in configs:
        confdir = confpath + "/config_{}c/".format(x*y)

        #  parse term log and get relevant information
        with open(confdir + "term", "r") as termlog:
            for line in termlog:
                partitions = line.partition(':')
                if partitions[0].strip() == "FFST (END)":
                    value = int(partitions[2])
                    ffst_end.write("{} {}\n".format(x*y, value))
                    break

    ffst_end.close()

if __name__ == "__main__":
    configs = []
    configs.append([2 , 2 ])
    configs.append([4 , 4 ])
    configs.append([8 , 8 ])
    configs.append([16, 16])

    assert len(sys.argv) > 2, "Introduce config path and output path"

    parse_ffstend(configs, sys.argv[1], sys.argv[2])
