#!/usr/bin/python
# @author Cesar Fuguet <cesar.fuguet-tortolero@lip6.fr>
# @date   28 August, 2014

import sys
import matplotlib.pyplot as pyplot

# get statistics file name
assert len(sys.argv) > 1, "Introduce the stats file"
filename = sys.argv[1]

clusters = []
cycles   = []

# parse the ffst stats file
with open(filename, 'r') as filedat:
    for line in filedat:
        partitions = line.split()
        if len(partitions) == 0: continue
        if partitions[0] == '#': continue

        if len(cycles) == 0:
            for i in xrange(len(partitions)-1):
                cycles.append([]);

        clusters.append(int(partitions[0]))
        for i in xrange(len(partitions)-1):
            if int(partitions[i+1]) == -1:
                cycles[i].append(None)
            else:
                cycles[i].append(int(partitions[i+1]))

# plot the different configurations
for c in xrange(len(cycles)):
    pyplot.plot(clusters, cycles[c], label = 'config{0}'.format(c), marker = 'o')

# x axis parameters
pyplot.xlabel('number of clusters')
pyplot.xticks(clusters)
pyplot.xlim(0, max(clusters))
#pyplot.xticks(xrange(0, 257, 64)
#pyplot.xscale('log', basex=2, subx=clusters)

# y axis parameters
pyplot.ylabel('number of cycles')

# show figure with legend and grid
pyplot.legend(loc = 'lower right')
pyplot.grid()
pyplot.show()

# vim: tabstop=4 : softtabstop=4 : shiftwidth=4 : expandtab
