#!/usr/bin/python
# @date   26 August, 2014
# @author cfuguet <cesar.fuguet-tortolero@lip6.fr>

import sys

def generate(faulty, outpath):
    content = []
    content.append( "#ifndef FAULT_CONFIG_H\n"
                    "#define FAULT_CONFIG_H\n"
                    "static const int faulty_proc_ids[] =\n"
                    "{\n"
                    "    /*  X    |    Y     | L  */\n")

    if faulty != None:
        for x, y, l in faulty:
            content.append("    ({0} << 6) | ({1} << 2) | {2},\n".format(x, y, l))

    content.append( "};\n"
                    "#endif\n")

    with open(outpath, "w") as outfile:
        outfile.writelines(content)

if __name__ == "__main__":
    faulty  = [ (0,0,1), (0,1,1), (1,0,1), (1,0,2), (1,0,3), (1,1,1), (1,1,3)]
    generate(faulty, "fault.gen.h")

# vim: tabstop=4 : softtabstop=4 : shiftwidth=4 : expandtab
