/**
 * \file    stdio.h
 * \date    July 8, 2014
 * \author  Cesar Fuguet
 *
 * \brief   input/output functions
 */
#ifndef _STDIO_H
#define _STDIO_H
#include <stdarg.h>

int getc(char *c);
void puts(const char *buffer);
void putc(const char c);
void sputs(const char *buffer, unsigned int length);
void putx(unsigned int val);
void putd(unsigned int val);

/**
 * Display a format on TTY0.
 * To provide an atomic display, this function takes the lock protecting
 * exclusive access to TTY0, entering a critical section until the lock
 * is released.
 * Only a limited number of formats are supported:
 *   - %d : 32 bits signed   decimal
 *   - %u : 32 bits unsigned decimal
 *   - %x : 32 bits unsigned hexa
 *   - %l : 64 bits unsigned hexa
 *   - %c : char
 *   - %s : string
 */
void printf(const char *format, ...);

void exit();

#endif                          /* _STDIO_H */

/*
 * vim: tabstop=4 : softtabstop=4 : shiftwidth=4 : expandtab
 */
