/**
 * \file    string.c
 * \date    July 8, 2014
 * \author  Cesar Fuguet
 *
 * \brief   string utility functions
 */
#include <string.h>

void *memset(void *_dst, int c, size_t len)
{
    const char val = (char)c;

    /*
     * Write 12 bytes when destination buffer is aligned to 4 bytes and length
     * is greater or equal to 12
     */
    int *dst = _dst;
    if (!((int)dst & 0x3)) {
        const int word = (val << 24) | (val << 16) | (val << 8) | val;
        while (len > 11) {
            dst[0] = word;
            dst[1] = word;
            dst[2] = word;
            len -= 12;
            dst += 3;
        }
    }

    /*
     * Write 1 byte when destination buffer is not aligned to 4 bytes or length
     * is smaller than 4
     */
    char *cdst = (char *)dst;
    while (len--) {
        *cdst++ = val;
    }

    return _dst;
}

void *memcpy(void *_dst, const void *_src, size_t n)
{
    uint8_t *cdst = (uint8_t *)_dst;
    uint8_t *csrc = (uint8_t *)_src;
    while (n--) {
        *cdst++ = *csrc++;
    }
    return _dst;
};

/*
 * vim: tabstop=4 : softtabstop=4 : shiftwidth=4 : expandtab
 */
