/**
 * \file   simhelper.h
 * \date   26 August, 2014
 * \author Cesar Fuguet <cesar.fuguet-tortolero@lip6.fr>
 *
 * \brief  simhelper driver
 */
#ifndef SIMHELPER_H
#define SIMHELPER_H

/**
 * \note the size of each register depends on the VCI cell size implemented by
 * the simhelper (i.e. when this component is connected to the external IO
 * network, this parameter is 8 bytes = 2x32 bits words).
 */
enum SoclibSimhelperRegisters {
    SIMH_STOP = 0,      /**< Write only */
    SIMH_EXIT = 1,      /**< Write only */
    SIMH_EXCEPTION = 2, /**< Write only */
    SIMH_PAUSE = 3,     /**< Write only */
    SIMH_CYCLES = 4,    /**< Read  only */
    SIMH_SIGINT = 5,    /**< Write only */

    SIMH_CELLSIZE = 2,  /**< Number of 32 bits words by register */
};

/**
 * \brief stop simulation by throwing a RunTimeError
 */
void simh_stop_simulation();

#endif

/*
 * vim: tabstop=4 : softtabstop=4 : shiftwidth=4 : expandtab
 */
