/**
 * \file   dspin_memcache_cc_test.h
 * \date   October 10, 2014
 * \author Cesar Fuguet <cesar.fuguet-tortolero@lip6.fr>
 */
#ifndef DSPIN_MEMCACHE_CC_TEST_H
#define DSPIN_MEMCACHE_CC_TEST_H

#include "caba_base_module.h"
#include "dspin_interface.h"
#include "dspin_dhccp_param.h"
#include <inttypes.h>

namespace soclib { namespace caba {

template<size_t M2P_WIDTH, size_t P2M_WIDTH>
class DspinMemcacheCcTest : public soclib::caba::BaseModule
{
    public:

        sc_core::sc_in<bool> p_clk;
        sc_core::sc_in<bool> p_resetn;
        DspinInput<M2P_WIDTH> p_dspin_m2p;
        DspinInput<M2P_WIDTH> p_dspin_clack;
        DspinOutput<P2M_WIDTH> p_dspin_p2m;

        DspinMemcacheCcTest(sc_module_name name);
        ~DspinMemcacheCcTest();

        inline void setSrcid(uint32_t srcid)
        {
            m_srcid = srcid;
        }

    private:

        typedef DspinDhccpParam FlitParam;

        SC_HAS_PROCESS(DspinMemcacheCcTest);
        void transition();
        void genMoore();

        /*
         * Internal attributes
         */
        uint32_t m_srcid;

        /*
         * GenTest FSM constants and registers
         */
        enum genTest_fsm_e
        {
            P2M_HEADER,
            P2M_SIGNATURE,
            WAIT_M2P_AND_CLACK,
            CHECK_SIGNATURE
        };

        sc_core::sc_signal<int> r_gen_test_fsm;
        sc_core::sc_signal<uint32_t> r_sign;

};                              /* class DspinMemcacheCcTest */

}                               /* namespace caba */
}                               /* namespace soclib */

#endif

/*
 * vim: ts=4 : sw=4 : sts=4 : et
 */
