#!/usr/bin/env sh
XSIZE=10
YSIZE=10
NPKTS=50

LOGDIR=logs
COMMON="-X $XSIZE -Y $YSIZE -P $NPKTS"
SCRIPTPATH=$(dirname $0)

# compile the platform
make
if [[ ! -f ./simul.x ]]; then exit 1; fi;

mkdir -p $LOGDIR
for (( x = 0; x < $XSIZE; x++ )); do
	for (( y = 0; y < $YSIZE; y++ )); do
		for (( fx = 0; fx < $XSIZE; fx++ )); do
			for (( fy = 0; fy < $YSIZE; fy++ )); do
				if [[ ( $x == $fx ) && ( $y == $fy ) ]]; then continue; fi
				LOGFILE=$LOGDIR/$(echo log'_'$x'_'$y'_'$fx'_'$fy);
				ARGS="$COMMON -SX $x -SY $y -FX $fx -FY $fy";
				echo "./simul.x $ARGS ($LOGFILE)"
				./simul.x $ARGS > $LOGFILE 2>/dev/null;
				$SCRIPTPATH/broadcast_check.sh $LOGFILE $NPKTS
				if [[ $? == 1 ]]; then
					echo "FAILURE";
					exit 1;
				fi
			done
		done
	done
done
