/**
 * \file   cpu_registers.h
 * \author Cesar Fuguet <cesar.fuguet-tortolero@lip6.fr>
 * \date   26/03/2012
 * \note   The mnemonics definitions for MIPS32 registers
 */

#ifndef _CPU_REGISTERS_H
#define _CPU_REGISTERS_H

/* processor registers */

#define zero $0
#define at   $at
#define v0   $2
#define v1   $3
#define a0   $4
#define a1   $5
#define a2   $6
#define a3   $7
#define t0   $8
#define t1   $9
#define t2   $10
#define t3   $11
#define t4   $12
#define t5   $13
#define t6   $14
#define t7   $15
#define s0   $16
#define s1   $17
#define s2   $18
#define s3   $19
#define s4   $20
#define s5   $21
#define s6   $22
#define s7   $23
#define t8   $24
#define t9   $25
#define k0   $26
#define k1   $27
#define gp   $28
#define sp   $29
#define fp   $30
#define ra   $31

/* CP0 registers */

#define CP0_COUNT  $9
#define CP0_STATUS $12,0
#define CP0_CAUSE  $13,0
#define CP0_EPC    $14,0
#define CP0_EBASE  $15,1
#define CP0_PROCID $15,1

/* CP0 cause register exception codes */

#define CR_INT  0x0
#define CR_ADEL 0x4
#define CR_ADES 0x5
#define CR_IBE  0x6
#define CR_DBE  0x7
#define CR_SYS  0x8
#define CR_RI   0xA

/* MMU (CP2) registers */

#define MMU_PTPR            $0
#define MMU_MODE            $1
#define MMU_ICACHE_FLUSH    $2
#define MMU_DCACHE_FLUSH    $3
#define MMU_ITLB_INVAL      $4
#define MMU_DTLB_INVAL      $5
#define MMU_ICACHE_INVAL    $6
#define MMU_DCACHE_INVAL    $7
#define MMU_ICACHE_PREFETCH $8
#define MMU_DCACHE_PREFETCH $9
#define MMU_SYNC            $10
#define MMU_IETR            $11
#define MMU_DETR            $12
#define MMU_IBVAR           $13
#define MMU_DBVAR           $14
#define MMU_PARAMS          $15
#define MMU_RELEASE         $16
#define MMU_DATA_LO         $17
#define MMU_DATA_HI         $18
#define MMU_ICACHE_INVAL_PA $19
#define MMU_DCACHE_INVAL_PA $20
#define MMU_DATA_PADDR_EXT  $24
#define MMU_INST_PADDR_EXT  $25

/* MMU IETR and DETR exception types */
#define MMU_NONE                      0x0000
#define MMU_WRITE_PT1_UNMAPPED        0x0001
#define MMU_WRITE_PT2_UNMAPPED        0x0002
#define MMU_WRITE_PRIVILEGE_VIOLATION 0x0004
#define MMU_WRITE_ACCES_VIOLATION     0x0008
#define MMU_WRITE_UNDEFINED_XTN       0x0020
#define MMU_WRITE_PT1_ILLEGAL_ACCESS  0x0040
#define MMU_WRITE_PT2_ILLEGAL_ACCESS  0x0080
#define MMU_WRITE_DATA_ILLEGAL_ACCESS 0x0100
#define MMU_READ_PT1_UNMAPPED         0x1001
#define MMU_READ_PT2_UNMAPPED         0x1002
#define MMU_READ_PRIVILEGE_VIOLATION  0x1004
#define MMU_READ_EXEC_VIOLATION       0x1010
#define MMU_READ_UNDEFINED_XTN        0x1020
#define MMU_READ_PT1_ILLEGAL_ACCESS   0x1040
#define MMU_READ_PT2_ILLEGAL_ACCESS   0x1080
#define MMU_READ_DATA_ILLEGAL_ACCESS  0x1100
#define MMU_READ_DATA_TIMEOUT         0x1200

/* CP2 MODE bit masks */

#define CP2_DCACHE_EN 0x1
#define CP2_ICACHE_EN 0x2
#define CP2_DTLB_EN   0x4
#define CP2_ITLB_EN   0x8

#endif                          /* _CPU_REGISTERS_H */

/*
 * vim: tabstop=4 : softtabstop=4 : shiftwidth=4 : expandtab
 */
