#!/usr/bin/env sh
# @author	Cesar Armando Fuguet Tortolero
# @date		24 May, 2015
# @brief
file=$1
awk '
BEGIN {
	total=0
	targets=0
}

#   Parse the broadcast latency
/broadcast latency +=/ {
	latency=$5;
	total+=latency;
	if (latency > 0) {
		targets++;
	}
}

#   Validate the file
END {
	print "mean latency=" total/targets
	exit 0;
}' $file
if [[ $? == 1 ]]; then exit 1; fi

