#include <systemc>
#include <vci_mem_cache.h>
#include <dspin_memcache_cc_test.h>
#include <int_tab.h>
#include <mapping_table.h>

/*
 * DSPIN parameters
 */
#define dspin_int_cmd_width 39
#define dspin_int_rsp_width 32
#define dspin_ram_cmd_width 64
#define dspin_ram_rsp_width 64

/*
 * VCI fields width
 */
#define vci_cell_width_int 4
#define vci_cell_width_ext 8
#define vci_plen_width 8
#define vci_address_width 40
#define vci_rerror_width 1
#define vci_clen_width 1
#define vci_rflag_width 1
#define vci_srcid_width 14
#define vci_pktid_width 4
#define vci_trdid_width 4
#define vci_wrplen_width 1

#define X_WIDTH 4
#define Y_WIDTH 4

int sc_main(int argc, char **argv)
{
    using namespace soclib::caba;
    using namespace soclib::common;

    typedef VciParams<vci_cell_width_int, vci_plen_width, vci_address_width,
            vci_rerror_width, vci_clen_width, vci_rflag_width, vci_srcid_width,
            vci_pktid_width, vci_trdid_width, vci_wrplen_width> VciParamInt;

    typedef VciParams<vci_cell_width_ext, vci_plen_width, vci_address_width,
            vci_rerror_width, vci_clen_width, vci_rflag_width, vci_srcid_width,
            vci_pktid_width, vci_trdid_width, vci_wrplen_width> VciParamExt;

    typedef VciMemCache< VciParamInt, VciParamExt, dspin_int_rsp_width,
            dspin_int_cmd_width> VciMemCacheT;

    typedef DspinMemcacheCcTest<dspin_int_cmd_width, dspin_int_rsp_width>
            DspinMemcacheCcTestT;

    MappingTable mt_int(
            vci_address_width,
            IntTab(X_WIDTH + Y_WIDTH, 16 - X_WIDTH - Y_WIDTH),
            IntTab(X_WIDTH + Y_WIDTH, vci_srcid_width - X_WIDTH - Y_WIDTH),
            0xF);

    mt_int.add(Segment("seg0", 0x0, 0x4000, IntTab(0, 0), false, false));

    MappingTable mt_ext(
            vci_address_width,
            IntTab(X_WIDTH + Y_WIDTH, 16 - X_WIDTH - Y_WIDTH),
            IntTab(X_WIDTH + Y_WIDTH, vci_srcid_width - X_WIDTH - Y_WIDTH),
            0xF);

    mt_ext.add(Segment("seg0", 0x0, 0x4000, IntTab(0, 0), false, false));

    VciMemCacheT memc(
            "memc", mt_int, mt_ext, IntTab(0, 0), IntTab(0, 0), 4, 4, 4, 256,
            16, 3, 4096, 8, 8, 8, 0, false);

    DspinMemcacheCcTestT memctest("memctest");

    sc_clock signal_clk("clk");
    sc_core::sc_signal<bool> signal_resetn("signal_resetn");
    VciSignals<VciParamExt> signal_ext_vci_ini("signal_ext_vci_ini");
    VciSignals<VciParamInt> signal_int_vci_tgt("signal_int_vci_tgt");
    DspinSignals<dspin_int_rsp_width> signal_dspin_p2m("signal_dspin_p2m");
    DspinSignals<dspin_int_cmd_width> signal_dspin_m2p("signal_dspin_m2p");
    DspinSignals<dspin_int_cmd_width> signal_dspin_clack("signal_dspin_clack");
    sc_core::sc_signal<bool> signal_irq("signal_irq");

    memc.p_clk(signal_clk);
    memc.p_resetn(signal_resetn);
    memc.p_vci_ixr(signal_ext_vci_ini);
    memc.p_vci_tgt(signal_int_vci_tgt);
    memc.p_dspin_p2m(signal_dspin_p2m);
    memc.p_dspin_m2p(signal_dspin_m2p);
    memc.p_dspin_clack(signal_dspin_clack);
    memc.p_irq(signal_irq);

    memctest.p_clk(signal_clk);
    memctest.p_resetn(signal_resetn);
    memctest.p_dspin_p2m(signal_dspin_p2m);
    memctest.p_dspin_m2p(signal_dspin_m2p);
    memctest.p_dspin_clack(signal_dspin_clack);

    sc_start(sc_core::SC_ZERO_TIME);
    signal_resetn = 0;
    signal_int_vci_tgt.cmdval = 0;
    signal_int_vci_tgt.rspack = 1;
    signal_ext_vci_ini.cmdack = 1;
    signal_ext_vci_ini.rspval = 0;
    signal_irq = 0;
    sc_start(sc_core::sc_time(5, SC_NS));
    signal_resetn = 1;
    sc_start(sc_core::sc_time(1000, SC_NS));

    std::cout << "failure" << std::endl;

    return 0;
}

/*
 * vim: ts=4 : sw=4 : sts=4 : et
 */
