#!/usr/bin/python
# @date   25 August, 2014
# @author cfuguet <cesar.fuguet-tortolero@lip6.fr>

import sys
import os
import subprocess
import arch
import faultyprocs

# define constants
configs = []
configs.append([2 ,2 ])
configs.append([4 ,4 ])
configs.append([8 ,8 ])
configs.append([16,16])

faultylist = [[(0,0,1), (0,1,1), (1,0,1), (1,0,2), (1,0,3), (1,1,1), (1,1,3)]]

nprocs = 4

assert len(sys.argv) > 1, "Introduce platform base directory path"

# translate the relative path (if needed) into an absolute path
basedir = os.path.abspath(sys.argv[1])
print "[ run.py ] platform base directory: {0}".format(basedir)

# repeat while configurations is not empty
for faulty in faultylist:
    for x,y in configs:
        confdir = "{0}/conf/config_{1}c".format(basedir, x*y)
        print "[ run.py ] generating files for {0}".format(confdir)

        # 1. generate configuration and ouput directories
        try:
            os.makedirs(confdir + "/config", 0755)
        except OSError:
            pass # directory already exists => do nothing

        # 2. generate hard_config.h and fault_config.h files
        arch.main( x = x, y = y, p = nprocs,
                   hard_path = confdir + "/config/hard_config.h",
                   xml_path = confdir + "/config/map.xml" )
        faultyprocs.generate(faulty, confdir + "/config/fault_config.h")

        # 3. compile simulator executable
        dst = basedir + "/hard_config.h"
        if os.path.lexists(dst): os.unlink(dst)
        os.symlink(confdir + "/config/hard_config.h", dst)
        subprocess.call(["make",
            "-C", basedir
            ])

        # 4. compile distributed boot executable
        dst = confdir + "/config/boot_config.h"
        if os.path.lexists(dst): os.unlink(dst)
        os.symlink(basedir + "/soft/config/boot_config.h", dst)
        subprocess.call(["make",
            "-C", basedir + "/soft",
            "CONFDIR=" + confdir
            ])

        # 5. execute simulator
        os.environ["DISTRIBUTED_BOOT"] = "1"
        os.environ["SOCLIB_TTY"] = "FILES"

        if x*y <= 4: ompthreads = x*y
        else:        ompthreads = 4
        with open(confdir + "/log", "w") as logfile:
            print "executing simul.x"
            subprocess.call([basedir + "/simul.x",
                "-SOFT"   , basedir + "/soft/build/soft.elf",
                "-DISK"   , "/dev/null",
                "-THREADS", str(ompthreads),
                "-NCYCLES", "1000000"],
                stdout=logfile,
                stderr=logfile,
                )

        # 6. move simulation terminal output into the target config dir
        os.rename("term0", confdir + "/term")

        # end for each config
    #end for each faulty

# vim: tabstop=4 : softtabstop=4 : shiftwidth=4 : expandtab
