#include "stdio.h"
#include "cpu.h"
#include "hard_config.h"
#include "io.h"
#include "simhelper.h"
#include "cpu_registers.h"

void exception_handler()
{
    printf("exception_handler(): pid %d\n", cpu_procid());

    int error = 0;
    if (cpu_get_cr_exccode() != CR_DBE) {
        printf("error: exccode should be DBE");
        error = 1;
    }
    if (cpu_get_mmu_detr() != MMU_READ_DATA_TIMEOUT) {
        printf("error: mmu data exception type should be WDT timeout");
        error = 1;
    }
    if (error == 0) {
        printf("success");
    }
    simh_stop_simulation();
}

void main(void)
{
    cpu_set_wdt_max(500);

    /*
     * Cause a WDT timeout exception
     * Trying to read a memory location of another (non-existent) cluster
     */
    ioread32(0xFF00000000ULL);
}

/* 
 * vim: tabstop=4 : softtabstop=4 : shiftwidth=4 : expandtab
 */
