#include <tty.h>
#include <io.h>
#include <hard_config.h>

#define TTYREG(x) (SEG_TTY_BASE + ((x)<<2))

int tty_getc(char *c)
{
    if (ioread32(TTYREG(TTY_STATUS)) == 0) {
        return 1;
    }
    *c = ioread32(TTYREG(TTY_READ));
    return 0;
}

void tty_putc(const char c)
{
    iowrite32(TTYREG(TTY_WRITE), (uint32_t)c);
}

/*
 * vim: tabstop=4 : softtabstop=4 : shiftwidth=4 : expandtab
 */
