/**
 * \file    assert.h
 * \author  Cesar FUGUET
 * \date    July 30, 2014
 * \brief   assert macro definition
 */
#ifndef ASSERT_H
#define ASSERT_H

#include <stdio.h>

/**
 * \param cond A boolean condition
 *
 * \brief assert condition
 * \note  the assert macro may be removed at compile time with the
 *        -DNDEBUG option
 */
#ifndef NDEBUG
#define assert(expression) {\
        if (!(expression)) {                                          \
            printf("assertion \"%s\" failed: file \"%s\", line %d\n", \
                #expression, __FILE__, __LINE__);                     \
            exit();                                                   \
        }                                                             \
    }
#else
#define assert(expression)
#endif

#endif

/*
 * vim: tabstop=4 : softtabstop=4 : shiftwidth=4 : expandtab
 */
