/*
 * \file        xcu.c
 * \author      Cesar Fuguet <cesar.fuguet-tortolero@lip6.fr>
 * \date        November 12, 2014
 */
#include <xcu.h>
#include <soclib/xicu.h>
#include <io.h>
#include <hard_config.h>
#include <cpu.h>

#define XCUREG(func,idx) (SEG_XCU_BASE + (XICU_REG((func),(idx)) << 2))

void xcu_set_config(int x, int y, int idx, uint32_t val)
{
    iowrite32(CLUSTER_BASE(x,y) | XCUREG(XICU_CFG_REG, idx), val);
}

uint32_t xcu_get_config(int x, int y, int idx)
{
    return ioread32(CLUSTER_BASE(x,y) | XCUREG(XICU_CFG_REG, idx));
}

/*
 * vim: tabstop=4 : softtabstop=4 : shiftwidth=4 : expandtab
 */
