#!/usr/bin/env python
# @author Cesar Fuguet <cesar.fuguet-tortolero@lip6.fr>
# @date   28 August, 2014

import sys
import matplotlib.pyplot as pyplot

# get statistics file name
assert len(sys.argv) > 1, "Introduce the stats file"
filename = sys.argv[1]

clusters = []
cycles   = []

# parse the ffst stats file
with open(filename, 'r') as filedat:
    # skip comment lines at the beginning of the file
    line = filedat.readline()
    while line[0] == '#': line = filedat.readline()

    # get the number of faultconfigs and init cycles array
    nfaultconfigs = int(line)
    for i in xrange(nfaultconfigs):
        cycles.append([]);

    # get the name of configurations
    faultconfigs = []
    for i in xrange(nfaultconfigs):
        line = filedat.readline()
        faultconfigs.append(line.rstrip('\n '))

    # read statistics
    # first column is the number of clusters (X axis)
    # other columns are number of cycles per fault configuration (Y axis)
    line = filedat.readline()
    while line != "":
        partitions = line.split()
        if len(partitions) == 0:
            line = filedat.readline()
            continue

        clusters.append(int(partitions[0]))
        for i in xrange(nfaultconfigs):
            if int(partitions[i+1]) == -1:
                cycles[i].append(None)
            else:
                cycles[i].append(int(partitions[i+1]))

        line = filedat.readline()

# plot the different configurations
for c in xrange(len(cycles)):
    pyplot.plot(clusters, cycles[c], label = faultconfigs[c], marker = 'o')

# x axis parameters
pyplot.xlabel('number of clusters')
pyplot.xticks(clusters)
pyplot.xlim(0, max(clusters))
#pyplot.xticks(xrange(0, 257, 64)
#pyplot.xscale('log', basex=2, subx=clusters)

# y axis parameters
pyplot.ylabel('number of cycles')

# show figure with legend and grid
pyplot.title('Number of Cycles per Mesh Dimensions and Faulty Cores')
pyplot.legend(loc = 'lower right')
pyplot.grid()
pyplot.show()

# vim: tabstop=4 : softtabstop=4 : shiftwidth=4 : expandtab
