/* -*- c++ -*-
 * SOCLIB_LGPL_HEADER_BEGIN
 * 
 * This file is part of SoCLib, GNU LGPLv2.1.
 * 
 * SoCLib is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; version 2.1 of the License.
 * 
 * SoCLib is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with SoCLib; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 * 
 * SOCLIB_LGPL_HEADER_END
 *
 * Authors  : Franck WAJSBRT, Abdelmalek SI MERABET 
 * Date     : january 2009
 * Copyright: UPMC - LIP6
 */

#ifndef SOCLIB_CABA_GATE_PORTS_H_
#define SOCLIB_CABA_GATE_PORTS_H_

#include "gate_signals_2.h"

namespace soclib { namespace caba {

template<int ring_cmd_data_size, int ring_rsp_data_size>
class GateTarget2
{
public:

	sc_core::sc_out<sc_dt::sc_uint<ring_cmd_data_size> > cmd_data;
	sc_core::sc_in<bool> cmd_wok;
	sc_core::sc_out<bool> cmd_w;

	sc_core::sc_in<sc_dt::sc_uint<ring_rsp_data_size> > rsp_data;
	sc_core::sc_out<bool> rsp_r;
	sc_core::sc_in<bool> rsp_rok;

	GateTarget2(const std::string &name = sc_core::sc_gen_unique_name("gate_target_2_"))
		:   cmd_data     ((name+"cmd_data").c_str()),
		    cmd_wok      ((name+"cmd_wok").c_str()),
                    cmd_w        ((name+"cmd_w").c_str()),

		    rsp_data     ((name+"rsp_data").c_str()),
		    rsp_r        ((name+"rsp_r").c_str()),
                    rsp_rok      ((name+"rsp_rok").c_str())
		{ }
    
	void operator () (GateSignals2<ring_cmd_data_size, ring_rsp_data_size> &sig)
	{
		
                cmd_data    		(sig.cmd_data);	
		cmd_wok    		(sig.cmd_r_wok);	
		cmd_w    		(sig.cmd_w_rok);	
		
		rsp_data    		(sig.rsp_data);
		rsp_r    		(sig.rsp_r_wok);
		rsp_rok    		(sig.rsp_w_rok);
		
	}

        void operator () (GateTarget2 &port)
	{
	      	cmd_data    		(port.cmd_data);	
		cmd_wok    		(port.cmd_wok);	
		cmd_w    		(port.cmd_w);	
		
		rsp_data    		(port.rsp_data);
		rsp_r    		(port.rsp_r);
		rsp_rok    		(port.rsp_rok);
  		
	}

};

template<int ring_cmd_data_size, int ring_rsp_data_size>
class GateInitiator2
{
public:
	
	sc_core::sc_in<sc_dt::sc_uint<ring_cmd_data_size> > cmd_data;
	sc_core::sc_out<bool> cmd_r;
	sc_core::sc_in<bool> cmd_rok;

	sc_core::sc_out<sc_dt::sc_uint<ring_rsp_data_size> > rsp_data;
	sc_core::sc_in<bool> rsp_wok;
	sc_core::sc_out<bool> rsp_w;
	
	GateInitiator2(const std::string &name = sc_core::sc_gen_unique_name("gate_initiator_2_"))
		:  

		cmd_data     ((name+"cmd_data").c_str()),
		cmd_r        ((name+"cmd_r").c_str()),
                cmd_rok      ((name+"cmd_rok").c_str()),

		rsp_data     ((name+"rsp_data").c_str()),
		rsp_wok      ((name+"rsp_wok").c_str()),
                rsp_w        ((name+"rsp_w").c_str())
    		{ }
    
	void operator () (GateSignals2<ring_cmd_data_size, ring_rsp_data_size> &sig)
	{
		cmd_data    		(sig.cmd_data);
		cmd_r    		(sig.cmd_r_wok);
		cmd_rok    		(sig.cmd_w_rok);
		
                rsp_data    		(sig.rsp_data);	
		rsp_wok    		(sig.rsp_r_wok);	
		rsp_w    		(sig.rsp_w_rok);
	}

        void operator () (GateInitiator2 &port)
	{

		cmd_data    		(port.cmd_data);
		cmd_r    		(port.cmd_r);
		cmd_rok    		(port.cmd_rok);

	      	rsp_data    		(port.rsp_data);	
		rsp_wok    		(port.rsp_wok);	
		rsp_w    		(port.rsp_w);
	}
	    
	
};

}}

#endif // SOCLIB_CABA_GATE_PORTS_H_


