#ifndef _TSAR_CONFIG_H_
#define _TSAR_CONFIG_H_

#define yes 1
#define no  0

///////////////////////////////////////////////////
//                Memory system          
///////////////////////////////////////////////////

#define USE_MEMCACHE_V3                       yes
#define USE_MEMCACHE_V4                       no

#define CONFIG_MEMC_UPDATE_TAB_LINES          4
#define CONFIG_MEMC_TRANSACTION_TAB_LINES     4

#define MEMC_WAYS                             16
#define MEMC_SETS                             256

#define L1_IWAYS                              4
#define L1_ISETS                              64

#define L1_DWAYS                              4
#define L1_DSETS                              64

#define TLB_IWAYS                             4
#define TLB_ISETS                             16

#define TLB_DWAYS                             4
#define TLB_DSETS                             16

#define CONFIG_XRAM_LATENCY                   0

///////////////////////////////////////////////////
//              Operating System
///////////////////////////////////////////////////

#define USE_ALMOS                yes


///////////////////////////////////////////////////
//              Peripheral Devices 
/////////////////////////////////////////////////// 

#define USE_FRAME_BUFFER         no

#define	SECTOR_SIZE	         4096
#define BDEV_IMAGE_NAME	         "hdd-img.bin"
#define BDEV_NAME_LEN            128

#define N_TTYS		         4

///////////////////////////////////////////////////
//               Parallelisation
///////////////////////////////////////////////////
#define USE_OPENMP               yes

///////////////////////////////////////////////////
//               Local-Interconnect
//////////////////////////////////////////////////
#define USE_LOCAL_RING           no

///////////////////////////////////////////////////
//               Global-Interconnect
///////////////////////////////////////////////////
#define VDSPIN_CMD_IN_LEN         4
#define VDSPIN_CMD_OUT_LEN        4
#define VDSPIN_RSP_IN_LEN         4
#define VDSPIN_RSP_OUT_LEN        4

///////////////////////////////////////////////////
//               Profiling & Debug
///////////////////////////////////////////////////

#define USE_LOGGER_ON_CPUs           no
#define USE_LOGGER_ON_DMA            no
#define USE_PROFILER_ON_CPUs         yes
#define USE_GDBSERVER                no

#define VCI_LOGGER_ON_ROM            no
#define VCI_LOGGER_ON_MC_IO          no
#define VCI_LOGGER_ON_MC0_D          no
#define VCI_LOGGER_ON_MC2_D          no
#define VCI_LOGGER_ON_BDEV           no

#define CONFIG_LOGGER_START_CYCLE    6000000

#define CONFIG_RING_IDEBUG           no
#define CONFIG_RING_HIDEBUG          no
#define CONFIG_RING_TDEBUG           no
#define CONFIG_RING_HTDEBUG          no


///////////////////////////////////////////////////
//        Physical Address Sapce         
///////////////////////////////////////////////////
// segments definition in direct space.
// There is 16 Mbytes address space per cluster.
// The 8 MSB bits define the cluster index (x,y),
// even if the number of clusters is less than 256.
// Each memory cache contains up to 12 Mbytes.
// There is one MEMC segment and one XICU segment 
// per cluster. The peripherals BDEV, FBUF, MTTY, 
// CDMA and the boot BROM are mapped in cluster 
// containing address 0xBFC00000
///////////////////////////////////////////////////

#define MEMC_BASE                0x00000000      
#define MEMC_SIZE                0x00C00000

#define BROM_BASE                0xBFC00000      
#define BROM_SIZE                0x00100000

#define FBUF_BASE                0xBFD00000      
#define FBUF_SIZE                0x00200000

#define XICU_BASE                0x00F00000      
#define XICU_SIZE                0x00002000

#define BDEV_BASE                0xBFF10000      
#define BDEV_SIZE                0x00000100

#define MTTY_BASE                0xBFF20000      
#define MTTY_SIZE                0x00000100

#define CDMA_BASE                0xBFF30000      
#define CDMA_SIZE                0x00000100


////////////////////////////////////////////////////////////////////
//     TGTID & SRCID definition in direct space
// For all components:  global TGTID = global SRCID = cluster_index
// For processors, the local SRCID is between 0 & nprocs-1
////////////////////////////////////////////////////////////////////

#define MEMC_TGTID               0
#define XICU_TGTID               1
#define FBUF_TGTID               2
#define MTTY_TGTID               3
#define BROM_TGTID               4
#define BDEV_TGTID               5
#define CDMA_TGTID               6

#define PROC_SRCID               0
#define BDEV_SRCID               nprocs
#define CDMA_SRCID               (nprocs+1)

#define CONFIG_ADDRESS_WIDTH     32

#endif	/* _TSAR_CONFIG_H_ */
