#!/bin/bash

#               archi1  archi2  archi3       archi4  archi5 
archi_name=(    "min"   "tsar"  "full_assoc" "2k"    "4k"   );
iways=(         "1"     "4"     "16"         "4"     "4"    );
isets=(         "8"     "64"    "1"          "8"     "16"   );
iwords=(        "16"    "16"    "16"         "16"    "16"   );
dways=(         "1"     "4"     "16"         "4"     "4"    );
dsets=(         "8"     "64"    "1"          "8"     "16"   );
dwords=(        "16"    "16"    "16"         "16"    "16"   );
memc_nways=(    "4"     "16"    "8"          "2"     "16"   );
memc_nsets=(    "4"     "256"   "64"         "32"    "64"   );
memc_words=(    "16"    "16"    "16"         "16"    "16"   );
memc_heap_size=("4096"  "4096"  "4096"       "4096"  "4096" );

nb_proc=(        "1" "15"   "+1" "4");
nb_cpu_by_cache=("1" "15"   "*2" "1");
nb_cache=(       "1" "16"   "*2" "1");
#wnwords=(        "1" "16"   "*2" "4");
#wnlines=(        "1" "8"    "*2" "8");

wnwords=(        "4"  "4"  "*2" "4");
wnlines=(        "8"  "8"  "*2" "8");

archi_default="1";
gen_cfg=0;

function gen_file ()
{
        filename=$(printf "archi_%s-x%.2d_%.2d_%.2d-wbuf_%.2d_%.2d_%.4d.cfg" ${archi_name[${4}]} ${1} ${2} ${3} ${5} ${6});

        echo ${filename};

        echo "${1}" >  ${filename};
        echo "${2} ${3}" >> ${filename};
        echo "${iways[${4}]} ${isets[${4}]} ${iwords[${4}]}" >> ${filename};
        echo "${dways[${4}]} ${dsets[${4}]} ${dwords[${4}]}" >> ${filename};
        echo "${5} ${6}" >> ${filename};
        echo "${memc_nways[${4}]} ${memc_nsets[${4}]} ${memc_words[${4}]} ${memc_heap_size[${4}]}" >> ${filename};
}

function gen_default ()
{
        filename="default.cfg";
        archi=${1};

        echo ${filename};

        echo "${nb_proc[3]}"  >  ${filename};
        echo "${nb_cpu_by_cache[3]} ${nb_cache[3]}" >> ${filename};
        echo "${iways[${archi}]} ${isets[${archi}]} ${iwords[${archi}]}" >> ${filename};
        echo "${dways[${archi}]} ${dsets[${archi}]} ${dwords[${archi}]}" >> ${filename};
        echo "${wnwords[3]} ${wnlines[3]}" >> ${filename};
        echo "${memc_nways[${archi}]} ${memc_nsets[${archi}]} ${memc_words[${archi}]} ${memc_heap_size[${archi}]}" >> ${filename};
}

gen_default ${archi_default};

if test ${gen_cfg} -ne 0; then
    nb_archi=${#iways[*]};
    
    num_archi=0;
    while test ${num_archi} -lt ${nb_archi}; do
        num_proc=${nb_proc[0]};
        while test ${num_proc} -le ${nb_proc[1]}; do
            num_cpu_by_cache=${nb_cpu_by_cache[0]};
            while test ${num_cpu_by_cache} -le ${nb_cpu_by_cache[1]}; do

                if test $((${num_proc} * ${num_cpu_by_cache})) -le ${nb_cpu_by_cache[1]}; then

                num_cache=${nb_cache[0]};
                while test ${num_cache} -le ${nb_cache[1]}; do
                
                    if test ${num_cache} -ge ${num_cpu_by_cache}; then
                    if test ${num_cpu_by_cache} -ne 1 -o ${num_cache} -eq 1; then

                    num_words=${wnwords[0]};
                    while test ${num_words} -le ${wnwords[1]}; do
                        num_lines=${wnlines[0]};
                        while test ${num_lines} -le ${wnlines[1]}; do
                            
                            gen_file ${num_proc} ${num_cpu_by_cache} ${num_cache} ${num_archi} ${num_words} ${num_lines};

                            num_lines=$((${num_lines} ${wnlines[2]}));
                        done;
                        num_words=$((${num_words} ${wnwords[2]}));
                    done;
                    fi;
                    fi;
                    num_cache=$((${num_cache} ${nb_cache[2]}));
                done;
                fi;
                num_cpu_by_cache=$((${num_cpu_by_cache} ${nb_cpu_by_cache[2]}));
            done;
            num_proc=$((${num_proc} ${nb_proc[2]}));
        done;
        num_archi=$((${num_archi}+1));
    done;
fi;

