#include "irq.h"
#include "system.h"
#include "stdio.h"

#include "../../segmentation.h"
#include "soclib/xicu.h"

void irq_handler (int irq)
{
  const int cpu = procnum();
  
  printf("Timer wrapped at cycle %d on cpu %d\n", cpu_cycles(), cpu);
  /* printf("Timer wrapped  on cpu %d\n", cpu); */

  soclib_io_get(base(XICU),
        	XICU_REG(XICU_PTI_ACK, cpu));
}
