#include "matrix_multiplication.h"
#include "stdio.h"
#include "system.h"
#include "stdint.h"

void matrix_multiplication_st (int ** a,
                               int ** b,
                               int ** d,
                               unsigned int n)
{
  uint32_t x, y;

  for (x=0; x<n; ++x)
    {
      printf("%d, ",x);

      for (y=0; y<n; ++y)
        {
          uint32_t i;

          int tmp = 0;
          for (i=0; i<n; ++i)
            tmp += a[x][i] * b[i][y];
          d[x][y] = tmp;
        }
    }
  
  printf("finish\n");
}

static uint32_t lock;
static uint32_t next;

void matrix_multiplication_mt (int ** a,
                               int ** b,
                               int ** d,
                               unsigned int n,
                               int lock_by_line)
{
  uint32_t x, y;

  while (1)
    {
      lock_lock(&lock);
      
      x=next++;
      
      lock_unlock(&lock);

      if (x >= n)
        break;
      
      printf("%d, ",x);
      for (y=0; y<n; ++y)
        {
          int line  =(lock_by_line)?x:y;
          int column=(lock_by_line)?y:x;
          
          int i;
          int tmp = 0;
          for (i=0; i<n; ++i)
            tmp += a[column][i] * b[i][line];
          d[column][line] = tmp;
        }
    }
  
  printf("finish\n");
}
