#include "system.h"
#include "stdio.h"
#include "stdlib.h"
//#include "matrice.h"

#include "../segmentation.h"

#define NPROCS 1
#define SIZE 50 
#define SORT_TYPE 0 // shellSort

volatile int nprocs=NPROCS;


unsigned int gQSortNum0[200] = {
  251,  24, 113, 170, 215,  60,  83,  30, 115,  48, 169, 210,  49,  92, 101,  58,  21, 184, 225,   6,
  199, 244, 227, 146,  99,  96,  25, 222,  65, 140, 213,  22, 219, 136, 175, 182,  73,  36, 141, 190, 
   83, 112, 137, 114, 175, 188, 187, 102,  53, 168, 193, 154, 167, 172,   3, 242,  67,  64, 144, 137,
  142, 175, 188,  69, 102,  53, 168, 193, 102,  89, 172, 253, 242,  67, 192,   7,  62, 159,  20, 181,
  182, 187, 216, 207,  22, 105, 132, 109, 162, 205,  16, 151,  18, 113, 228,  37,   6,  85,   8, 161,
   58, 135,  76,  35, 174,  35, 224,  39, 158, 127, 180, 149,  86, 155, 200, 239, 118, 119,  28,  77,
  254,  19, 176, 183,  78, 145, 132,   5,  90, 117, 152, 127, 218, 153,  20,  67, 178,   3, 128, 185,
  254,  95, 172, 139, 246, 123, 104,  15,  42, 169,  68, 211,  98, 243,  80,  41, 174,  79,  36,  27,
  186, 149,  86, 155, 200, 239, 118, 119,  28,  77, 254,  19, 176, 183,  78, 145, 132,   5,  90, 117,
  152, 127, 218, 153,  20,  67, 178,   3, 128, 185, 254,  95, 172, 139, 246, 123, 104,  15,  42, 169 };


unsigned int SortArr0[NPROCS*(SIZE+50)];

void shellSortPhase(unsigned int a[],unsigned int length, int gap);
void shellSort(unsigned int *base, unsigned int n);     // type 0

int main()
{
  register int p; 

  int beg_cycle, end_cycle;

  beg_cycle = cpu_cycles();

  p=procnum();

  puts("Hello from processor ");
  putchar(p+'0');
  putchar('\n');

  int i;
  int j;
  unsigned int* SortArray;

  if(p+1 <= nprocs)
  {
        i=1;
  	puts("Memory copy \n");
        SortArray = SortArr0 + p*(SIZE+50);
	memcpy(SortArray, gQSortNum0 + p*SIZE,SIZE*4);

 	puts("Sort... \n");
        shellSort((unsigned int *) (SortArray), (unsigned int) SIZE);

  	for (j = 1; j < SIZE; j++)
    	{
	  if (SortArray[j] < SortArray[j-1])
		{
	  		puts("ucbqsort: failed\n");
			while(1);
		}

    	}

  	puts("ucbqsort: success\n");
        end_cycle = cpu_cycles();
//      printf( "nombre cycles cpu : %i\n", end_cycle-beg_cycle);
        printf( "begin time        : %i\n", beg_cycle);
        printf( "end time          : %i\n", end_cycle);
  }


  while(1);
}

//------------------------------------------------------
/*
 * Excute un tri par insertion avec la sparation donne
 * If gap == 1, on fait un tri ordinaire.
 * If gap >= length, on ne fait rien.
 */
void shellSortPhase(unsigned int a[],unsigned int length, int gap) {
    int i;
 
    puti(gap);
    for (i = gap; i < length; ++i) {
        unsigned int value = a[i];
        int j;
        for (j = i - gap; j >= 0 && a[j] > value; j -= gap) {
	    putchar('+');
            a[j + gap] = a[j];
	    putchar('-');
        }
        a[j + gap] = value;
    }
}
 
void shellSort(unsigned int *base, unsigned int n) {
    /*
     * gaps[] doit approximer une Srie gomtrique.
     * La sequence suivante est la meilleure connue en terme
     * de nombre moyen de comparaisons. voir:
     * http://www.research.att.com/~njas/sequences/A102549
     */
    static const int gaps[] = {
        1, 4, 10, 23, 57, 132, 301, 701
    };
    int sizeIndex;
 
    puts("Shell Sort\n");
    for (sizeIndex = sizeof(gaps)/sizeof(gaps[0]) - 1;
               sizeIndex >= 0;
               --sizeIndex)
        shellSortPhase(base, n, gaps[sizeIndex]);
}

