/*****************************************************/
/* Various timer routines.                           */
/* Al Aburto, aburto@nosc.mil, 18 Feb 1997           */
/*                                                   */
/* t = dtime() outputs the current time in seconds.  */
/* Use CAUTION as some of these routines will mess   */
/* up when timing across the hour mark!!!            */
/*                                                   */
/* For timing I use the 'user' time whenever         */
/* possible. Using 'user+sys' time is a separate     */
/* issue.                                            */
/*                                                   */
/* Example Usage:                                    */
/* [timer options added here]                        */
/* main()                                            */
/* {                                                 */
/* double starttime,benchtime,dtime();               */
/*                                                   */
/* starttime = dtime();                              */ 
/* [routine to time]                                 */
/* benchtime = dtime() - starttime;                  */
/* }                                                 */
/*                                                   */
/* [timer code below added here]                     */
/*****************************************************/

/*********************************/
/* Timer code.                   */
/*********************************/

#include "dhry.h"
#include "system.h"

/***************************************************/
/*  dtime().                                       */
/***************************************************/
#ifdef HAVE_DOUBLE
# ifndef MHZ
# define MHZ (1000000.0)
# endif //!MHZ

# ifndef FRQ
# define FRQ (1*MHZ)
# endif //!FRQ
#endif

DOUBLE dtime()
{
  DOUBLE q;

#ifdef HAVE_DOUBLE
  q = (DOUBLE)(cpu_cycles())/(DOUBLE)FRQ;
#else
  q = (DOUBLE)(cpu_cycles());
#endif

  return (q);
}
