
/////////////////////////////////////////////////////////////////
//	ADDRESS SPACE SEGMENTATION
//
//	This file must be included in the system.cpp file, 
//	for harware configuration : It is used to build
//	the SOCLIB_SEGMENT_TABLE.
//
//	This file can also be used by the ldscript generator,
//	for embedded software generation.
//	
//	It gives the system integrator the garanty
//	that hardware and software have the same
//	description of the address space segmentation.
/////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////
//	reset, and exception segments
//      base address required by MIPS processor
/////////////////////////////////////////////////////////////////
#define	RESET_BASE	0xBFC00000
#define	RESET_SIZE	0x00010000

#define	EXCEP_BASE	0x80000000
#define	EXCEP_SIZE	0x00010000

#define	TEXT_BASE	0x00400000
#define	TEXT_SIZE	0x00050000

/////////////////////////////////////////////////////////////////
//	global data segment (initialised)
/////////////////////////////////////////////////////////////////

#define MC_M_BASE	0x10000000
#define MC_M_SIZE	0x000F0000

#define MC_R_BASE	0x20200000
#define MC_R_SIZE	0x00000008

#define MC_U_BASE	0x30000000
#define MC_U_SIZE	0x000F0000

//////////////////////////////////////////////////////////
//	System devices
///////////////////////////////////////////////////////////

#define	TTY_BASE	0xC0200000
#define	TTY_SIZE	0x00000100

#define	XICU_BASE	0xD0200000
#define	XICU_SIZE	0x00000100

#define	SIMHELPER_BASE  0xF0200000
#define	SIMHELPER_SIZE	0x00000100

#define C_PROC_BASE	0x01200000
#define C_PROC_SIZE	0x00000010
#define C_PROC_SPAN     0x01000000
