#include "irq.h"
#include "system.h"
#include "stdio.h"
#include "../define.h"
#include "../../segmentation.h"
#include "soclib/xicu.h"

void irq_init ()
{
  int cpu=procnum();
  
  printf("irq_init : %d\n",cpu);
  
  set_irq_handler(irq_handler);
  
  soclib_io_set(base(XICU),
                XICU_REG(XICU_PTI_PER, cpu),
                TIMER_INTERRUPT_PERIOD);
  
  soclib_io_set(base(XICU),
                XICU_REG(XICU_MSK_PTI, cpu),
                1);

  enable_hw_irq(0);
  irq_enable();
}

