/********************************************************************************/
/*	File        : mips32_registers.h											*/
/*	Author      : Alain Greiner													*/
/*	Date        : 26/03/2012													*/
/*  Modified by : Cesar Fuguet 10/02/2013										*/
/********************************************************************************/
/* 	We define mnemonics for MIPS32 registers             	 					*/
/********************************************************************************/

#ifndef _MIPS32_REGISTERS_H
#define _MIPS32_REGISTERS_H

/* processor registers */

#define zero            $0
#define at              $at
#define v0              $2
#define v1              $3
#define a0              $4
#define a1              $5
#define a2              $6
#define a3              $7
#define t0              $8
#define t1              $9
#define t2              $10
#define t3              $11
#define t4              $12
#define t5              $13
#define t6              $14
#define t7              $15
#define s0              $16
#define s1              $17
#define s2              $18
#define s3              $19
#define s4              $20
#define s5              $21
#define s6              $22
#define s7              $23
#define t8              $24
#define t9              $25
#define k0              $26
#define k1              $27
#define gp              $28
#define sp              $29
#define fp              $30
#define ra              $31

/* CP0 registers */

#define CP0_COUNT       $9
#define CP0_STATUS      $12,0
#define CP0_CAUSE       $13,0
#define CP0_EPC         $14,0
#define CP0_EBASE       $15,1

#endif
