/****************************************************************************************
    File : drivers.h
    Written by Alain Greiner & Nicolas Pouillon
    Date : september 2009

    These system calls are used by the MIPS GIET, that is running
    on the MIPS32 processor architecture.

    The supported peripherals are:
    - the SoClib vci_multi_tty
    - the SocLib vci_multi_timer
    - the SocLib vci_dma
    - The SoCLib vci_icu
    - The SoCLib vci_gcd
    - The SoCLib vci_frame_buffer
    - The SoCLib vci_block_device
****************************************************************************************/

#ifndef _DRIVERS_H_
#define _DRIVERS_H_

#include "tty.h"
#include "dma.h"
#include "gcd.h"
#include "timer.h"
#include "icu.h"
#include "block_device.h"

typedef unsigned int    size_t;

// global variables defined in giet.s

extern  unsigned int    _task_context_array[];
extern  unsigned int    _current_task_array[];
extern  unsigned int    _task_number_array[];

// function defined in giet.s

void _ctx_switch();

// global variables defined in drivers.c

extern  int volatile	_dma_status[];
extern  int volatile	_dma_busy[];

extern  int volatile	_ioc_lock;
extern  int volatile	_ioc_done;
extern  int volatile	_ioc_status;

extern  char volatile	_tty_get_buf[];
extern  int volatile	_tty_get_full[];

extern  char volatile	_tty_put_buf[];
extern  int volatile	_tty_put_full[];

// functions defined in drivers.c

unsigned int 	_procid();
unsigned int 	_proctime();
unsigned int 	_procnumber();

unsigned int 	_segment_increment();

void _itoa_dec(unsigned int val, char* buf);
void _itoa_hex(int val, char* buf);

int _exit();

int _timer_write(size_t timer_index, size_t register_index, int value);
int _timer_read(size_t timer_index, size_t register_index, int* buffer);

int _tty_write(char* buffer, int length);
int _tty_read(char* buffer, int length);

int _io_write(size_t lba, void* buffer, size_t count);
int _io_read(size_t lba, void* buffer, size_t count);
int _io_completed();

int _icu_write(size_t register_index, int  value);
int _icu_read(size_t register_index, int*  buffer);

int _gcd_write(size_t register_index, int  value);
int _gcd_read(size_t register_index, int*  buffer);

int _locks_write(size_t lock_index);
int _locks_read(size_t lock_index);

int _fb_sync_write(size_t offset, void* buffer, size_t length);
int _fb_sync_read(size_t offset, void* buffer, size_t length);

int _fb_write(size_t offset, void* buffer, size_t length);
int _fb_read(size_t offset, void* buffer, size_t length);
int _fb_completed();

int _barrier_init(size_t index, size_t count);
int _barrier_wait(size_t index);

#endif

// Local Variables:
// tab-width: 4;
// c-basic-offset: 4;
// c-file-offsets:((innamespace . 0)(inline-open . 0));
// indent-tabs-mode: nil;
// End:
//
// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

