#ifndef BOOT_IOC_H
#define BOOT_IOC_H

#ifndef SOCLIB_IOC
    #include <sdcard.h>
    #include <spi.h>
#else
    #include <block_device.h>
#endif

#include <defs.h>
#include <boot_tty.h>
#include <io.h>

/**
 * boot_ioc_read()
 * 
 * Transfer data from a file on the block device to a memory buffer.
 *
 * \param lba    : first block index on the disk
 * \param buffer : base address of the memory buffer
 * \param count  : number of blocks to be transfered
 *
 * \note This is a blocking function. The function returns once the transfer
 *       has finished
 */
int boot_ioc_read(unsigned int lba, void* buffer, unsigned int count);

/**
 * boot_ioc_init()
 *
 * Initialize the SPI controller use to access a SD card
 */
int boot_ioc_init();

/**
 * boot_dbuf_invalidate()
 *
 * Invalidate all data cache lines corresponding to a memory buffer.
 */
#if (CACHE_COHERENCE == 0)
void boot_dbuf_invalidate(
        const void * buffer,
        unsigned int line_size,
        unsigned int size);
#endif

/**
 * boot_ioc_write()
 *
 * Transfer data from a memory buffer to a file on the block_device.
 *
 * \param lba    : first block index on the disk
 * \param buffer : base address of the memory buffer
 * \param count  : number of blocks to be transfered
 *
 * \note The source buffer must be in user address space.
 */
//int boot_ioc_write(unsigned int lba, void* buffer, unsigned int count);

#endif

/*
 * vim: tabstop=4 : shiftwidth=4 : expandtab
 */
