#include "benchmark.h"
#include "system.h"
#include "stdio.h"
#include "../common/common.h"

void benchmark (void)
{
  int result      = 0;
  int num_cpu     = procnum();
  int cycle_begin = cycle_begin = cpu_cycles();
  
  if (num_cpu < BENCHMARK_NB_THREAD)
   switch (num_cpu)
     {
     default :
        {
#if BENCHMARK_MATRIX_MULTIPLICATION_MT
          int result_mm_mt = benchmark_matrix_multiplication_mt();
          result += result_mm_mt;
#endif
#if BENCHMARK_DHRYSTONE
          int result_dhrystone = benchmark_dhrystone();
          result += result_dhrystone;
#endif
#if BENCHMARK_SORT_ALL
          int result_sort_all = benchmark_sort_all();
          result += result_sort_all;
#endif
#if BENCHMARK_SORT_BUBBLE
          int result_sort_bubble = benchmark_sort_bubble();
          result += result_sort_bubble;
#endif
#if BENCHMARK_SORT_INSERTION
          int result_sort_insertion = benchmark_sort_insertion();
          result += result_sort_insertion;
#endif
#if BENCHMARK_SORT_SELECTION
          int result_sort_selection = benchmark_sort_selection();
          result += result_sort_selection;
#endif
#if BENCHMARK_SORT_SHELL
          int result_sort_shell = benchmark_sort_shell();
          result += result_sort_shell;
#endif
#if BENCHMARK_MATRIX_MULTIPLICATION_ST
          int result_mm_st = benchmark_matrix_multiplication_st();
          result += result_mm_st;
#endif
#if BENCHMARK_SELF_CODE_MODIFYING
          int result_self_code_modifying = benchmark_self_code_modifying();
          result += result_self_code_modifying;
#endif
          
          printf("\n");
          printf("--------------------------------\n");
          printf( "Partial results :\n");
#if BENCHMARK_MATRIX_MULTIPLICATION_MT
          printf(" * MM MT               : %d\n",result_mm_mt);
#endif
#if BENCHMARK_DHRYSTONE
          printf(" * DHRYSTONE           : %d\n",result_dhrystone);
#endif
#if BENCHMARK_SORT_ALL
          printf(" * SORT_ALL            : %d\n",result_sort_all);
#endif
#if BENCHMARK_SORT_BUBBLE
          printf(" * SORT_BUBBLE         : %d\n",result_sort_bubble);
#endif
#if BENCHMARK_SORT_INSERTION
          printf(" * SORT_INSERTION      : %d\n",result_sort_insertion);
#endif
#if BENCHMARK_SORT_SELECTION
          printf(" * SORT_SELECTION      : %d\n",result_sort_selection);
#endif
#if BENCHMARK_SORT_SHELL
          printf(" * SORT_SHELL          : %d\n",result_sort_shell);
#endif
#if BENCHMARK_MATRIX_MULTIPLICATION_ST
          printf(" * MM ST               : %d\n",result_mm_st);
#endif 
#if BENCHMARK_SELF_CODE_MODIFYING
          printf(" * SELF_CODE_MODIFYING : %d\n",result_self_code_modifying);
#endif
          printf("--------------------------------\n");
          break;
        }
      }

  printf("\n");
  printf("================================\n");
  printf( "Results :\n");
  printf( " * Score           : %d\n", result);
  printf( " * Total CPU Cycle : %d\n", cpu_cycles()-cycle_begin);
  printf("================================\n");
}
