/*
   This file is part of MutekP.
  
   MutekP is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   MutekP is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with MutekP; if not, write to the Free Software Foundation,
   Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
  
   UPMC / LIP6 / SOC (c) 2009
   Copyright Ghassan Almaless <ghassan.almaless@gmail.com>
*/


/////////////////////////////////////////
//   Devices mapped segments 
/////////////////////////////////////////
#define     SIMH_BASE	0xf1000000
#define     SIMH_SIZE	0x00010000

#define     XICU_BASE   0xfd000000
#define     XICU_SIZE   0x00001000

#define	    DMA_BASE	0xf2000000
#define	    DMA_SIZE	0x00000014

#define     TTY_BASE    0xfc000000
#define     TTY_SIZE    0x00000010

#define     BD_BASE     0xfb000000
#define     BD_SIZE     0x20

#define FB_XSIZE 640
#define FB_YSIZE 480
#define	     FB_BASE	0xf0000000
#define      FB_SIZE	FB_XSIZE*FB_YSIZE*4
////////////////////////////////////////


//////////////////////////////////////////
//       ROM mapped segments
//////////////////////////////////////////

#define    BOOT_BASE       0xbfc00000
#define    BOOT_SIZE       0x00400000

#define    DTB_BASE	   0xbfd00000
#define    DTB_SIZE	   0x00002000

#define    ROM_BASE        BOOT_BASE
#define    ROM_SIZE        (DTB_BASE+DTB_SIZE-ROM_BASE)
//////////////////////////////////////////

//////////////////////////////////////////
//                RAM
//////////////////////////////////////////

#define     RAM_BASE    0x00000000
#define     RAM_SIZE    0x10000000
//////////////////////////////////////////

//////////////////////////////////////////
//    Application mapped segments
//////////////////////////////////////////

#define  KTEXT_BASE       0x80000000
#define  KDATA_BASE       0x80020000
#define  KDATA_SIZE       0x003E0000

#define     USR_TEXT_BASE    0x7F400000
#define     USR_DATA_BASE    0x7F402000
#define     USR_DATA_SIZE    0X00BFD000
////////////////////////////////////////

////////////////////////////////////////
//	Reserved segments
////////////////////////////////////////

#define PROC0_BASE	0x11200000
#define PROC0_SIZE	0x00000020

#define PROC1_BASE	0x12200000
#define PROC1_SIZE	0x00000020

#define PROC2_BASE	0x13200000
#define PROC2_SIZE	0x00000020

#define PROC3_BASE	0x14200000
#define PROC3_SIZE	0x00000020

////////////////////////////////////////
