#include "benchmark.h"
#include "system.h"
#include "stdlib.h"
#include "stdio.h"
#include "../dhrystone/dhry21.h"

static uint32_t nb_thread;

int _benchmark_dhrystone (unsigned int nb_runs)
{
  printf("\n");
  printf("================================\n");
  printf("Benchmark Dhrystone\n");
  printf("================================\n");
  printf("\n");

  int result = 0;
  
  if (atomic_inc(&nb_thread) == 1)
    {
      result = dhry21(nb_runs);
    }
  else
    {
      printf("The dhrystone benchmark is not multi threaded.\n");
    }
    
  return result;
}

int benchmark_dhrystone (void) { return _benchmark_dhrystone(DHRYSTONE_NB_RUNS); }
