
/////////////////////////////////////////////////////////////////
//	ADDRESS SPACE SEGMENTATION
//
//	This file must be included in the system.cpp file, 
//	for harware configuration : It is used to build
//	the SOCLIB_SEGMENT_TABLE.
//
//	This file can also be used by the ldscript generator,
//	for embedded software generation.
//	
//	It gives the system integrator the garanty
//	that hardware and software have the same
//	description of the address space segmentation.
/////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////
//	reset, and exception segments
//      base address required by MIPS processor
/////////////////////////////////////////////////////////////////
#define MMU

#define	RESET_BASE	0x00BFC00000
#define	RESET_SIZE	0x00010000

#define	EXCEP_BASE	0x0080000080
#define	EXCEP_SIZE	0x00010000

#define	TEXT_BASE	0x0000400000
#define	TEXT_SIZE	0x00050000
/////////////////////////////////////////////////////////////////
//	global data segment (initialised)
/////////////////////////////////////////////////////////////////

#define MC_M_BASE	0x0010000000
#define MC_M_SIZE	0x00100000

//////////////////////////////////////////////////////////
//	System devices
///////////////////////////////////////////////////////////

#define	TTY_BASE	0x00C0200000
#define	TTY_SIZE	0x00000100

#define	TIMER_BASE	0x00D0200000
#define	TIMER_SIZE	0x00000100

#define	LOCKS_BASE	0x00E0200000
#define	LOCKS_SIZE	0x00000100

#define C_PROC0_BASE	0x0001200000
#define C_PROC0_SIZE	0x00000010

#define C_PROC1_BASE	0x0002200000
#define C_PROC1_SIZE	0x00000010

#define C_PROC2_BASE	0x0003200000
#define C_PROC2_SIZE	0x00000010

#define C_PROC3_BASE	0x0004200000
#define C_PROC3_SIZE	0x00000010


#define CLEANUP_OFFSET  0x20200000
