#include "../include/tsarv4_cluster_xbar.h"

namespace soclib {
namespace caba  {

//////////////////////////////////////////////////////////////////////////
//                 Constructor
//////////////////////////////////////////////////////////////////////////
template<typename vci_param, typename iss_t, int cmd_width, int rsp_width>
TsarV4ClusterXbar<vci_param, iss_t, cmd_width, rsp_width>::TsarV4ClusterXbar(
                        sc_module_name  insname,
                        size_t          nprocs,
                        size_t          x_id,
                        size_t          y_id,
                        size_t          cluster_id,
                        const   	soclib::common::MappingTable &mtd,
                        const   	soclib::common::MappingTable &mtc, 
                        const   	soclib::common::MappingTable &mtx, 
                        size_t          x_width,
                        size_t          y_width,
                        size_t		tgtid_memc,
                        size_t		tgtid_xicu,
                        size_t		tgtid_fbuf,
                        size_t		tgtid_mtty,
                        size_t		tgtid_brom,
                        size_t		tgtid_bdev,
                        size_t		tgtid_mdma,
                        size_t		memc_ways,
                        size_t		memc_sets,
                        size_t		l1_i_ways,
                        size_t		l1_i_sets,
                        size_t		l1_d_ways,
                        size_t		l1_d_sets,
                        size_t		xram_latency,
                        bool            io,
                        size_t		xfb,
                        size_t		yfb,
                        size_t          fb_mode,
                        char*		disk_name,
                        size_t		block_size,
                        const Loader	&loader)
      : soclib::caba::BaseModule(insname),
        p_clk("clk"),
        p_resetn("resetn"),

        signal_dspin_cmd_l2g_d("signal_dspin_cmd_l2g_d"),
        signal_dspin_cmd_g2l_d("signal_dspin_cmd_g2l_d"),
        signal_dspin_cmd_l2g_c("signal_dspin_cmd_l2g_c"),
        signal_dspin_cmd_g2l_c("signal_dspin_cmd_g2l_c"),
        signal_dspin_rsp_l2g_d("signal_dspin_rsp_l2g_d"),
        signal_dspin_rsp_g2l_d("signal_dspin_rsp_g2l_d"),
        signal_dspin_rsp_l2g_c("signal_dspin_rsp_l2g_c"),
        signal_dspin_rsp_g2l_c("signal_dspin_rsp_g2l_c"),

	signal_vci_ini_d_bdev("signal_vci_ini_d_bdev"),
	signal_vci_ini_d_cdma("signal_vci_ini_d_cdma"),

        signal_vci_tgt_d_memc("signal_vci_tgt_d_memc"),
        signal_vci_tgt_d_mtty("signal_vci_tgt_d_mtty"),
        signal_vci_tgt_d_xicu("signal_vci_tgt_d_xicu"),
        signal_vci_tgt_d_bdev("signal_vci_tgt_d_bdev"),
        signal_vci_tgt_d_cdma("signal_vci_tgt_d_cdma"),
        signal_vci_tgt_d_brom("signal_vci_tgt_d_brom"),
        signal_vci_tgt_d_fbuf("signal_vci_tgt_d_fbuf"),

        signal_vci_ini_c_memc("signal_vci_ini_c_memc"), 
        signal_vci_tgt_c_memc("signal_vci_tgt_c_memc"),

        signal_vci_xram("signal_vci_xram")

{
        // Vectors of ports definition

        p_cmd_in        = alloc_elems<DspinInput<cmd_width> >("p_cmd_in", 2, 4);
        p_cmd_out       = alloc_elems<DspinOutput<cmd_width> >("p_cmd_out", 2, 4);
        p_rsp_in        = alloc_elems<DspinInput<rsp_width> >("p_rsp_in", 2, 4);
        p_rsp_out       = alloc_elems<DspinOutput<rsp_width> >("p_rsp_out", 2, 4);
	
        // Components definition 

        // on direct network : local srcid[proc] in [0...nprocs-1]
        // on direct network : local srcid[mdma] = nprocs
        // on direct network : local srcid[bdev] = nprocs + 1

        // on coherence network : local srcid[proc] in [0...nprocs-1]
	// on coherence network : local srcid[memc] = nprocs

std::cout << "  - building proc_" << x_id << "_" << y_id << "-*" << std::endl;

        for ( size_t p=0 ; p<nprocs ; p++ )
        { 
	  std::ostringstream sproc;
	  sproc << "proc_" << x_id << "_" << y_id << "_" << p;

#if USE_MEMCACHE_V4
            proc[p] = new VciCcXCacheWrapperV4<vci_param, iss_t>(
                sproc.str().c_str(),
                cluster_id*nprocs + p,
                mtd,				// Mapping Table Direct
                mtc,				// Mapping Table Coherence
                IntTab(cluster_id,p),    	// SRCID_D
                IntTab(cluster_id,p),    	// SRCID_C
                IntTab(cluster_id,p),    	// TGTID_C
                1,				// single core
                1,				// single dcache
                l1_i_ways,l1_i_sets,16,  	// ICACHE size
                l1_d_ways,l1_d_sets,16,      	// DCACHE size
                4,				// WBUF width
                8 				// WBUF depth
                );
#endif	// USE_MEMCACHE_V4

#if USE_MEMCACHE_V3
	    proc[p] = new VciCcVCacheWrapper2V1<vci_param, iss_t>(
								  sproc.str().c_str(),
								  cluster_id*nprocs + p,
								  mtd, mtc,
								  IntTab(cluster_id,p),     // SRCID_D
								  IntTab(cluster_id,p),     // SRCID_C
								  IntTab(cluster_id,p),     // TGTID_C
								  TLB_IWAYS,TLB_ISETS,TLB_DWAYS,TLB_DSETS,
								  l1_i_ways,l1_i_sets,16,
								  l1_d_ways,l1_d_sets,16,
								  16);      // TLB, Icache and Dcache sizes
#endif	// USE_MEMCACHE_V3

#if USE_PROFILER_ON_CPUs
	    std::ostringstream sp;
	    sp << "profiler_" << x_id << "_" << y_id << "-" << p;
	    
	    profiler[p] = new VciProfiler <vci_param, iss_t> (sp.str().c_str(), 
							      cluster_id,
							      x_id,
							      y_id,
							      x_width,
							      y_width, 
							      CONFIG_ADDRESS_WIDTH);
	    profiler[p]->p_clk                  (this->p_clk);
	    profiler[p]->p_resetn               (this->p_resetn);
	    profiler[p]->p_vci                  (signal_vci_ini_d_proc[p]);
	    profiler[p]->set_L1_cache(proc[p]);
#endif	// USE_PROFILER_ON_CPUs

#if USE_LOGGER_ON_CPUs
	    std::ostringstream sp2;
	    sp2 << "logger_" << x_id << "_" << y_id << "-" << p;
	    vci_logger[p] = new VciLogger <vci_param> (sp2.str().c_str(), mtd);
	    vci_logger[p]->p_clk    (this->p_clk);
	    vci_logger[p]->p_resetn (this->p_resetn);
	    vci_logger[p]->p_vci (signal_vci_ini_d_proc[p]);
#endif	// USE_LOGGER_ON_CPUs

        } // for on CPUs number

std::cout << "  - building memc_" << x_id << "_" << y_id << std::endl;

        std::ostringstream smemc;
        smemc << "memc_" << x_id << "_" << y_id;

#if USE_MEMCACHE_V4
        memc = new VciMemCacheV4<vci_param>(
                   smemc.str().c_str(),
                   mtd, mtc, mtx,
                   IntTab(cluster_id),           	// SRCID_X
                   IntTab(cluster_id, nprocs),   	// SRCID_C
                   IntTab(cluster_id, tgtid_memc),	// TGTID_D
                   IntTab(cluster_id, nprocs),   	// TGTID_C
                   memc_ways, memc_sets, 16,	 	// CACHE SIZE
                   4096,     			 	// HEAP SIZE
                   8,					// TRANSACTION TABLE DEPTH
                   8);					// UPDATE TABLE DEPTH
#endif

#if USE_MEMCACHE_V3
	memc = new VciMemCacheV3<vci_param>(
					    smemc.str().c_str(),
					    mtd, mtc, mtx,
					    IntTab(cluster_id),                   	// SRCID_X
					    IntTab(cluster_id, nprocs),           	// SRCID_C
					    IntTab(cluster_id, tgtid_memc),        	// TGTID_D
					    IntTab(cluster_id, nprocs),           	// TGTID_C
					    memc_ways, memc_sets, 16,
					    4096); 
#endif	// USE_MEMCACHE_V3

        
std::cout << "  - building xram_" << x_id << "_" << y_id << std::endl;

        std::ostringstream sxram;
        sxram << "xram_" << x_id << "_" << y_id;
        xram = new VciSimpleRam<vci_param>(
                   sxram.str().c_str(),
                   IntTab(cluster_id),
                   mtx,
                   loader,
                   xram_latency);

std::cout << "  - building xicu_" << x_id << "_" << y_id << std::endl;

        //size_t  nhwi = 8;				// always 8 (or 9) ports, even if 
        //if( io == true ) nhwi = 9;			// there if less than 4 processors


         size_t   nhwi = 0;
	 if(io == true) nhwi = 6;

        std::ostringstream sicu;
        sicu << "xicu_" << x_id << "_" << y_id;
        xicu = new VciXicu<vci_param>(
                  sicu.str().c_str(),
                  mtd,				  	// mapping table
                  IntTab(cluster_id, tgtid_xicu),  	// TGTID_D
                  nprocs,				// number of timer IRQs
                  nhwi,                          	// number of hard IRQs
                  nprocs,				// number of soft IRQs
                  nprocs);				// number of output IRQs

std::cout << "  - building xbard_" << x_id << "_" << y_id << std::endl;

        // direct local crossbar
        size_t nb_direct_initiators      = nprocs;
        size_t nb_direct_targets         = 2;

        if( io == true )
        {
            nb_direct_initiators         = nprocs + 2;
            nb_direct_targets            = 7;
	}

        std::ostringstream sd;
        sd << "xbard_" << x_id << "_" << y_id;

#if USE_LOCAL_RING
	xbard = new VciLocalRingFast<vci_param,cmd_width,rsp_width>(
		    sd.str().c_str(),
		    mtd,
		    IntTab(cluster_id),              // cluster index
		    4,                               // wrapper fifo depth
		    18,                              // gateway fifo depth
		    nb_direct_initiators ,           // number of initiators
		    nb_direct_targets);              // number of targets			
#else
        xbard = new VciLocalCrossbar<vci_param>(
                    sd.str().c_str(),
                    mtd,
                    IntTab(cluster_id),              	// cluster initiator index
                    IntTab(cluster_id),              	// cluster target index
                    nb_direct_initiators,           	// number of initiators
                    nb_direct_targets);             	// number of targets      
#endif // USE_LOCAL_RING

        
std::cout << "  - building xbarc_" << x_id << "_" << y_id << std::endl;

        // coherence local crossbar
        std::ostringstream sc;
        sc << "xbarc_" << x_id << "_" << y_id;

#if USE_LOCAL_RING
        xbarc = new VciLocalRingFast<vci_param,cmd_width,rsp_width>(
		     sc.str().c_str(),
		     mtc,
		     IntTab(cluster_id),                   	// cluster index
		     4,                                      	// wrapper fifo depth
		     18,                                     	// gateway fifo depth
		     nprocs + 1,                               	// number of initiators
		     nprocs + 1);                              	// number of targets
	
#else
        xbarc = new VciLocalCrossbar<vci_param>(
                    sc.str().c_str(),
                    mtc,
                    IntTab(cluster_id),                	// cluster initiator index
                    IntTab(cluster_id),                	// cluster target index
                    nprocs + 1,                		// number of initiators
                    nprocs + 1);               		// number of targets
#endif  // USE_LOCAL_RING 

#if !(USE_LOCAL_RING)
std::cout << "  - building wrappers in cluster_" << x_id << "_" << y_id << std::endl;

        // direct initiator wrapper
        std::ostringstream wid;
        wid << "iniwrapperd_" << x_id << "_" << y_id;
        iniwrapperd = new VciVdspinInitiatorWrapper<vci_param,cmd_width,rsp_width>(
                          wid.str().c_str(),
                          4,				// cmd fifo depth
                          4);				// rsp fifo depth

        // direct target wrapper
        std::ostringstream wtd;
        wtd << "tgtwrapperd_" << x_id << "_" << y_id;
        tgtwrapperd = new VciVdspinTargetWrapper<vci_param,cmd_width,rsp_width>(
                          wtd.str().c_str(),
                          4,				// cmd fifo depth
                          4);				// rsp fifo depth

        // coherence initiator wrapper
        std::ostringstream wic;
        wic << "iniwrapperc_" << x_id << "_" << y_id;
        iniwrapperc = new VciVdspinInitiatorWrapper<vci_param,cmd_width,rsp_width>(
                          wic.str().c_str(),
                          4,				// cmd fifo depth
                          4);				// rsp fifo depth

        // coherence target wrapper
        std::ostringstream wtc;
        wtc << "tgtwrapperc_" << x_id << "_" << y_id;
        tgtwrapperc = new VciVdspinTargetWrapper<vci_param,cmd_width,rsp_width>(
                          wtc.str().c_str(),
                          4,				// cmd fifo depth
                          4);				// rsp fifo depth
#endif	// !(USE_LOCAL_RING)

std::cout << "  - building cmdrouter_" << x_id << "_" << y_id << std::endl;

        // CMD router
        std::ostringstream scmd;
        scmd << "cmdrouter_" << x_id << "_" << y_id;
        cmdrouter = new VirtualDspinRouter<cmd_width>(
                        scmd.str().c_str(),
                        x_id,y_id,                    // coordinate in the mesh
                        x_width, y_width,             // x & y fields width
                        4,4);                         // input & output fifo depths
        
std::cout << "  - building rsprouter_" << x_id << "_" << y_id << std::endl;

        // RSP router
        std::ostringstream srsp;
        srsp << "rsprouter_" << x_id << "_" << y_id;
        rsprouter = new VirtualDspinRouter<rsp_width>(
                        srsp.str().c_str(),
                        x_id,y_id,                    // coordinates in mesh
                        x_width, y_width,             // x & y fields width
                        4,4);                         // input & output fifo depths
        
        // IO cluster components
        if ( io == true )
	{
            brom = new VciSimpleRam<vci_param>(
                       "brom",
                       IntTab(cluster_id, tgtid_brom),
                       mtd,
                       loader);

#if USE_FRAME_BUFFER
            fbuf = new VciFrameBuffer<vci_param>(
                       "fbuf",
                       IntTab(cluster_id, tgtid_fbuf),
                       mtd,
		       xfb, 
		       yfb,
		       fb_mode); 
#else
	    std::ostringstream sf;
	    sd << "fb_logger__" << x_id << "_" << y_id;
	    fbuf = new VciLogger <vci_param> (sd.str().c_str(), mtd);
#endif

	    cdma = new VciDmaTsarV2<vci_param>(
		      "cdma", 
		      mtd, 
		      IntTab(cluster_id, nprocs),
		      IntTab(cluster_id, tgtid_mdma),
		      64);

#if USE_LOGGER_ON_DMA
	    std::ostringstream sd;
	    sd << "dma_logger_" << x_id << "_" << y_id;
	    vci_dma_logger = new VciLogger <vci_param> (sd.str().c_str(), mtd);
	    vci_dma_logger->p_clk    (this->p_clk);
	    vci_dma_logger->p_resetn (this->p_resetn);
	    vci_dma_logger->p_vci (signal_vci_ini_d_cdma);
#endif	// USE_LOGGER_ON_DMA

	    bdev = new VciBlockDeviceTsarV2<vci_param>(
                       "bdev",
                       mtd,
                       IntTab(cluster_id, nprocs+1),
                       IntTab(cluster_id, tgtid_bdev),
                       disk_name,
                       block_size);

	    // tty
	    signal_irq_mtty = alloc_elems<sc_signal<bool> >("signal_irq_mtty", 4);

	    std::ostringstream stty;
	    stty << "tty_" << x_id << "_" << y_id;
	    mtty = new VciMultiTty<vci_param>(
					      stty.str().c_str(),
					      IntTab(cluster_id, tgtid_mtty),
					      mtd, "tty0", "tty1", "tty2", "tty3", NULL);
	}

std::cout << "  - all components constructed" << std::endl;

        ////////////////////////////////////
        // Connections are defined here
        ////////////////////////////////////

        // CMDROUTER and RSPROUTER
        cmdrouter->p_clk                	(this->p_clk);
        cmdrouter->p_resetn             	(this->p_resetn);
        rsprouter->p_clk                	(this->p_clk);
        rsprouter->p_resetn             	(this->p_resetn);
        for(int x = 0; x < 2; x++)
        {
          for(int y = 0; y < 4; y++)
          {
            cmdrouter->p_out[x][y]              (this->p_cmd_out[x][y]);
            cmdrouter->p_in[x][y]               (this->p_cmd_in[x][y]);
            rsprouter->p_out[x][y]              (this->p_rsp_out[x][y]);
            rsprouter->p_in[x][y]               (this->p_rsp_in[x][y]);
          }
        }
        
        cmdrouter->p_out[0][4]  		(signal_dspin_cmd_g2l_d);
        cmdrouter->p_out[1][4]  		(signal_dspin_cmd_g2l_c);
        cmdrouter->p_in[0][4]   		(signal_dspin_cmd_l2g_d);
        cmdrouter->p_in[1][4]   		(signal_dspin_cmd_l2g_c);

        rsprouter->p_out[0][4]  		(signal_dspin_rsp_g2l_d);
        rsprouter->p_out[1][4]  		(signal_dspin_rsp_g2l_c);
        rsprouter->p_in[0][4]   		(signal_dspin_rsp_l2g_d);
        rsprouter->p_in[1][4]   		(signal_dspin_rsp_l2g_c);

#if !(USE_LOCAL_RING)
        // VCI/DSPIN WRAPPERS
        iniwrapperd->p_clk			(this->p_clk);
        iniwrapperd->p_resetn			(this->p_resetn);
	iniwrapperd->p_vci			(signal_vci_l2g_d);
	iniwrapperd->p_dspin_out		(signal_dspin_cmd_l2g_d);
	iniwrapperd->p_dspin_in			(signal_dspin_rsp_g2l_d);

        tgtwrapperd->p_clk			(this->p_clk);
        tgtwrapperd->p_resetn			(this->p_resetn);
	tgtwrapperd->p_vci			(signal_vci_g2l_d);
	tgtwrapperd->p_dspin_out		(signal_dspin_rsp_l2g_d);
	tgtwrapperd->p_dspin_in			(signal_dspin_cmd_g2l_d);

        iniwrapperc->p_clk			(this->p_clk);
        iniwrapperc->p_resetn			(this->p_resetn);
	iniwrapperc->p_vci			(signal_vci_l2g_c);
	iniwrapperc->p_dspin_out		(signal_dspin_cmd_l2g_c);
	iniwrapperc->p_dspin_in			(signal_dspin_rsp_g2l_c);

        tgtwrapperc->p_clk			(this->p_clk);
        tgtwrapperc->p_resetn			(this->p_resetn);
	tgtwrapperc->p_vci			(signal_vci_g2l_c);
	tgtwrapperc->p_dspin_out		(signal_dspin_rsp_l2g_c);
	tgtwrapperc->p_dspin_in			(signal_dspin_cmd_g2l_c);
#endif

        // CROSSBAR direct
        xbard->p_clk                  		(this->p_clk);
        xbard->p_resetn                 	(this->p_resetn);

#if USE_LOCAL_RING
	xbard->p_gate_cmd_out                   (signal_dspin_cmd_l2g_d);
        xbard->p_gate_cmd_in                    (signal_dspin_cmd_g2l_d);
        xbard->p_gate_rsp_out                   (signal_dspin_rsp_l2g_d);
        xbard->p_gate_rsp_in                    (signal_dspin_rsp_g2l_d);
#else
        xbard->p_initiator_to_up        	(signal_vci_l2g_d);
        xbard->p_target_to_up           	(signal_vci_g2l_d);
#endif     
        xbard->p_to_target[tgtid_memc]  	(signal_vci_tgt_d_memc);
        xbard->p_to_target[tgtid_xicu]  	(signal_vci_tgt_d_xicu);          
        
        for ( size_t p=0 ; p<nprocs ; p++)
            xbard->p_to_initiator[p]		(signal_vci_ini_d_proc[p]);

	if ( io == true )
	{
            xbard->p_to_target[tgtid_brom]  	(signal_vci_tgt_d_brom);
            xbard->p_to_target[tgtid_bdev]  	(signal_vci_tgt_d_bdev);
            xbard->p_to_target[tgtid_fbuf]  	(signal_vci_tgt_d_fbuf);
	    xbard->p_to_target[tgtid_mtty]  	(signal_vci_tgt_d_mtty);
	    xbard->p_to_target[tgtid_mdma]  	(signal_vci_tgt_d_cdma);

	    xbard->p_to_initiator[nprocs]  	(signal_vci_ini_d_cdma);
            xbard->p_to_initiator[nprocs+1]  	(signal_vci_ini_d_bdev);
	}
        
        // CROSSBAR coherence
        xbarc->p_clk                    	(this->p_clk);
        xbarc->p_resetn                 	(this->p_resetn);

#if USE_LOCAL_RING
	xbarc->p_gate_cmd_out                   (signal_dspin_cmd_l2g_c);
        xbarc->p_gate_cmd_in                    (signal_dspin_cmd_g2l_c);
        xbarc->p_gate_rsp_out                   (signal_dspin_rsp_l2g_c);
        xbarc->p_gate_rsp_in                    (signal_dspin_rsp_g2l_c);
#else
        xbarc->p_initiator_to_up        	(signal_vci_l2g_c);
        xbarc->p_target_to_up           	(signal_vci_g2l_c);
#endif
        xbarc->p_to_initiator[nprocs]  		(signal_vci_ini_c_memc);
        xbarc->p_to_target[nprocs]     		(signal_vci_tgt_c_memc);

        for ( size_t p=0 ; p<nprocs ; p++)
        {
            xbarc->p_to_target[p]       	(signal_vci_tgt_c_proc[p]);
            xbarc->p_to_initiator[p]    	(signal_vci_ini_c_proc[p]);
        }

        // Processors
        for ( size_t p=0 ; p<nprocs ; p++)
        {
            proc[p]->p_clk              	(this->p_clk);
            proc[p]->p_resetn           	(this->p_resetn);
            proc[p]->p_vci_ini_rw       	(signal_vci_ini_d_proc[p]);
            proc[p]->p_vci_ini_c        	(signal_vci_ini_c_proc[p]);
            proc[p]->p_vci_tgt          	(signal_vci_tgt_c_proc[p]);
            proc[p]->p_irq[0]           	(signal_proc_it[p]);

            for ( size_t j = 1 ; j < 6 ; j++ )
                proc[p]->p_irq[j]       	(signal_false);
        }
        
        // XICU
        xicu->p_clk                     	(this->p_clk);
        xicu->p_resetn                  	(this->p_resetn);
        xicu->p_vci                     	(signal_vci_tgt_d_xicu);

        for ( size_t p=0 ; p<nprocs ; p++)
	  xicu->p_irq[p]              	(signal_proc_it[p]);
	
        // MEMC
        memc->p_clk                     	(this->p_clk);
        memc->p_resetn                  	(this->p_resetn);
        memc->p_vci_ixr                 	(signal_vci_xram);
        memc->p_vci_tgt                 	(signal_vci_tgt_d_memc);
        memc->p_vci_ini                 	(signal_vci_ini_c_memc);
        memc->p_vci_tgt_cleanup         	(signal_vci_tgt_c_memc);

        // XRAM
        xram->p_clk                     	(this->p_clk);
        xram->p_resetn                  	(this->p_resetn);
        xram->p_vci                 		(signal_vci_xram);

	// Components in IO cluster
	if ( io == true )
	{
        	// BDEV            
		bdev->p_clk                      (this->p_clk);
        	bdev->p_resetn                   (this->p_resetn);
        	bdev->p_irq                      (signal_irq_bdev);
        	bdev->p_vci_target               (signal_vci_tgt_d_bdev);
        	bdev->p_vci_initiator            (signal_vci_ini_d_bdev);

        	// FBUF
        	fbuf->p_clk                       (this->p_clk);
        	fbuf->p_resetn                    (this->p_resetn);
        	fbuf->p_vci                       (signal_vci_tgt_d_fbuf);

        	// BROM
        	brom->p_clk                       (this->p_clk);
        	brom->p_resetn                    (this->p_resetn);
        	brom->p_vci                       (signal_vci_tgt_d_brom);
		
		// MTTY
		mtty->p_clk                       (this->p_clk);
		mtty->p_resetn                    (this->p_resetn);
		mtty->p_vci                       (signal_vci_tgt_d_mtty);
		for(size_t i=0 ; i<4 ; i++)
		  mtty->p_irq[i]                   (signal_irq_mtty[i]);

		// CDMA
		cdma->p_clk                       (this->p_clk);
		cdma->p_resetn                    (this->p_resetn);
		cdma->p_irq                       (signal_irq_cdma);
		cdma->p_vci_target                (signal_vci_tgt_d_cdma);
		cdma->p_vci_initiator             (signal_vci_ini_d_cdma);

		xicu->p_hwi[0]             (signal_irq_bdev);
		xicu->p_hwi[1]             (signal_irq_cdma);
		
		for(size_t i=0 ; i<4 ; i++)
		  xicu->p_hwi[2+i]        (signal_irq_mtty[i]);
        }
} // end constructor

///////////////////////////////////////////////////////////////////////////
//    destructor
///////////////////////////////////////////////////////////////////////////
template<typename vci_param, typename iss_t, int cmd_width, int rsp_width>
TsarV4ClusterXbar<vci_param, iss_t, cmd_width, rsp_width>::~TsarV4ClusterXbar() {}

}}
