#include <systemc>
#include <sys/time.h>
#include <iostream>
#include <cstdlib>
#include <cstdarg>

#include "mapping_table.h"
#include "dspin_local_ring_fast_c.h"
#include "soclib_vci_initiator.h"
#include "soclib_vci_target.h"
#include "alloc_elems.h"
#include "vci_param.h"
#include "virtual_dspin_router.h"

// Router ports index
#define NORTH		0
#define SOUTH		1
#define EAST		2
#define WEST		3
#define LOCAL		4

#define X_MAX           2
#define Y_MAX           2
#define cmd_width	40
#define rsp_width	33
#define X_WIDTH         1
#define Y_WIDTH         1
#define SRCID_WIDTH     14

#define cluster(x,y)    (y+x*Y_MAX)

#define CYCLES 10000000

int _main(int argc, char *argv[])
{
	using namespace sc_core;
	// Avoid repeating these everywhere
	using soclib::common::IntTab;
	using soclib::common::Segment;
        using soclib::common::alloc_elems;
	using namespace soclib::caba;

	// Define VCI parameters
	typedef soclib::caba::VciParams<4,8,32,1,1,1,14,4,4,1> vci_param;

       // Mapping table primary network
        soclib::common::MappingTable maptabp(32, IntTab(X_WIDTH + Y_WIDTH, SRCID_WIDTH - X_WIDTH - Y_WIDTH), IntTab(X_WIDTH + Y_WIDTH, SRCID_WIDTH - X_WIDTH - Y_WIDTH), 0x00FF0000);
   	for (size_t x = 0; x < X_MAX; x++)
   	{
      		for (size_t y = 0; y < Y_MAX; y++)
      		{
         		sc_uint<32> offset  = cluster(x,y) << (32 - X_WIDTH - Y_WIDTH);

        		for ( size_t p = 0 ; p < 4 ; p++) 
        		{
        			std::ostringstream sp;
        			sp << "c_seg_proc_" << x << "_" << y << "_" << p;
        			maptabp.add( Segment( sp.str() , (p << (32 - SRCID_WIDTH)) + offset , 0x10 , IntTab(cluster(x,y), p) , false)); 
        		}
		}
	}
/*
	soclib::common::MappingTable maptabp(32, IntTab(2,12), IntTab(2,12), 0xFF000000);

	maptabp.add(Segment("target_0_0" , 0x00000000 , 0x00001000 , IntTab(0,0), true ));
	maptabp.add(Segment("target_1_0" , 0x40000000 , 0x00001000 , IntTab(1,0), true ));
	maptabp.add(Segment("target_1_1" , 0x40000000 , 0x00001000 , IntTab(1,1), true ));
	maptabp.add(Segment("target_2_0" , 0x80000000 , 0x00001000 , IntTab(2,0), true ));
	maptabp.add(Segment("target_2_1" , 0xC0000000 , 0x00001000 , IntTab(3,0), true ));
*/
	// Signals

	sc_clock	signal_clk("clk");
	sc_signal<bool> signal_resetn("resetn");

        DspinSignals<40> dspin_cmd[4][5];
        DspinSignals<33> dspin_rsp[4][5];

	//--- Dspin router 
	DspinSignals<cmd_width>*** signal_dspin_false_cmd_in  = alloc_elems<DspinSignals<cmd_width> >("signal_dspin_false_cmd_in", (Y_MAX*X_MAX), 2, 2);
	DspinSignals<cmd_width>*** signal_dspin_false_cmd_out = alloc_elems<DspinSignals<cmd_width> >("signal_dspin_false_cmd_out", (Y_MAX*X_MAX), 2, 2);
	DspinSignals<rsp_width>*** signal_dspin_false_rsp_in  = alloc_elems<DspinSignals<rsp_width> >("signal_dspin_false_rsp_in", (Y_MAX*X_MAX), 2, 2);
	DspinSignals<rsp_width>*** signal_dspin_false_rsp_out = alloc_elems<DspinSignals<rsp_width> >("signal_dspin_false_rsp_out", (Y_MAX*X_MAX), 2, 2);


	// DSPIN signals between local ring & global interconnects
	DspinSignals<cmd_width>** signal_dspin_cmd_l2g_d =
	    alloc_elems<DspinSignals<cmd_width> >("signal_dspin_cmd_l2g_d", X_MAX, Y_MAX);
	DspinSignals<cmd_width>** signal_dspin_cmd_g2l_d =
	    alloc_elems<DspinSignals<cmd_width> >("signal_dspin_cmd_g2l_d", X_MAX, Y_MAX);
	
	DspinSignals<cmd_width>** signal_dspin_cmd_l2g_c =
	    alloc_elems<DspinSignals<cmd_width> >("signal_dspin_cmd_l2g_c", X_MAX, Y_MAX);
	DspinSignals<cmd_width>** signal_dspin_cmd_g2l_c =
	    alloc_elems<DspinSignals<cmd_width> >("signal_dspin_cmd_g2l_c", X_MAX, Y_MAX);
	
	DspinSignals<rsp_width>** signal_dspin_rsp_l2g_d =
	    alloc_elems<DspinSignals<rsp_width> >("signal_dspin_rsp_l2g_d", X_MAX, Y_MAX);
	DspinSignals<rsp_width>** signal_dspin_rsp_g2l_d =
	    alloc_elems<DspinSignals<rsp_width> >("signal_dspin_rsp_g2l_d", X_MAX, Y_MAX);
	
	DspinSignals<rsp_width>** signal_dspin_rsp_l2g_c =
	    alloc_elems<DspinSignals<rsp_width> >("signal_dspin_rsp_l2g_c", X_MAX, Y_MAX);
	DspinSignals<rsp_width>** signal_dspin_rsp_g2l_c =
	    alloc_elems<DspinSignals<rsp_width> >("signal_dspin_rsp_g2l_c", X_MAX, Y_MAX);
	
	// Horizontal inter-clusters DSPIN signals
	DspinSignals<cmd_width>*** signal_dspin_h_cmd_inc =
	    alloc_elems<DspinSignals<cmd_width> >("signal_dspin_h_cmd_inc", X_MAX-1, Y_MAX, 2);
	DspinSignals<cmd_width>*** signal_dspin_h_cmd_dec =
	    alloc_elems<DspinSignals<cmd_width> >("signal_dspin_h_cmd_dec", X_MAX-1, Y_MAX, 2);
	DspinSignals<rsp_width>*** signal_dspin_h_rsp_inc =
	    alloc_elems<DspinSignals<rsp_width> >("signal_dspin_h_rsp_inc", X_MAX-1, Y_MAX, 2);
	DspinSignals<rsp_width>*** signal_dspin_h_rsp_dec =
	    alloc_elems<DspinSignals<rsp_width> >("signal_dspin_h_rsp_dec", X_MAX-1, Y_MAX, 2);

	// Vertical inter-clusters DSPIN signals
	DspinSignals<cmd_width>*** signal_dspin_v_cmd_inc =
	    alloc_elems<DspinSignals<cmd_width> >("signal_dspin_v_cmd_inc", X_MAX, Y_MAX-1, 2);
	DspinSignals<cmd_width>*** signal_dspin_v_cmd_dec =
	    alloc_elems<DspinSignals<cmd_width> >("signal_dspin_v_cmd_dec", X_MAX, Y_MAX-1, 2);
	DspinSignals<rsp_width>*** signal_dspin_v_rsp_inc =
	    alloc_elems<DspinSignals<rsp_width> >("signal_dspin_v_rsp_inc", X_MAX, Y_MAX-1, 2);
	DspinSignals<rsp_width>*** signal_dspin_v_rsp_dec =
	    alloc_elems<DspinSignals<rsp_width> >("signal_dspin_v_rsp_dec", X_MAX, Y_MAX-1, 2);

	soclib::caba::SoclibVciInitiator<40,33>  initp0("initp0", 0,    16, X_WIDTH, Y_WIDTH, X_MAX, Y_MAX);
	soclib::caba::SoclibVciInitiator<40,33>  initp1("initp1", 4096, 16, X_WIDTH, Y_WIDTH, X_MAX, Y_MAX); 
	soclib::caba::SoclibVciInitiator<40,33>  initp2("initp2", 8192, 16, X_WIDTH, Y_WIDTH, X_MAX, Y_MAX);
	soclib::caba::SoclibVciInitiator<40,33>  initp3("initp3", 12288,16, X_WIDTH, Y_WIDTH, X_MAX, Y_MAX);

	soclib::caba::SoclibVciTarget<40,33>  target0_0("target0_0", 0   ); 
	soclib::caba::SoclibVciTarget<40,33>  target0_1("target0_1", 1   );
	soclib::caba::SoclibVciTarget<40,33>  target0_2("target0_2", 2   );
	soclib::caba::SoclibVciTarget<40,33>  target0_3("target0_3", 3   );

	soclib::caba::SoclibVciTarget<40,33>  target1_0("target1_0", 4   ); 
	soclib::caba::SoclibVciTarget<40,33>  target1_1("target1_1", 5   );
	soclib::caba::SoclibVciTarget<40,33>  target1_2("target1_2", 6   );
	soclib::caba::SoclibVciTarget<40,33>  target1_3("target1_3", 7   );

	soclib::caba::SoclibVciTarget<40,33>  target2_0("target2_0", 8   ); 
	soclib::caba::SoclibVciTarget<40,33>  target2_1("target2_1", 9   );
	soclib::caba::SoclibVciTarget<40,33>  target2_2("target2_2", 10  );
	soclib::caba::SoclibVciTarget<40,33>  target2_3("target2_3", 11  );

	soclib::caba::SoclibVciTarget<40,33>  target3_0("target3_0", 12  ); 
	soclib::caba::SoclibVciTarget<40,33>  target3_1("target3_1", 13  );
	soclib::caba::SoclibVciTarget<40,33>  target3_2("target3_2", 14  );
	soclib::caba::SoclibVciTarget<40,33>  target3_3("target3_3", 15  );

	// Local ring interconnects : 1 direct ring per cluster
	soclib::caba::DspinLocalRingFastC<vci_param, 40, 33> * clusterPN = (soclib::caba::DspinLocalRingFastC<vci_param, 40, 33> *) malloc(sizeof(soclib::caba::DspinLocalRingFastC<vci_param, 40, 33> )*4);
	
	new(&clusterPN[0]) soclib::caba::DspinLocalRingFastC<vci_param, 40, 33>("clusterPN0",maptabp, IntTab(0), 2, 2, 1, 4, 1, 1 );
	new(&clusterPN[1]) soclib::caba::DspinLocalRingFastC<vci_param, 40, 33>("clusterPN1",maptabp, IntTab(1), 2, 2, 1, 4, 1, 1 );
	new(&clusterPN[2]) soclib::caba::DspinLocalRingFastC<vci_param, 40, 33>("clusterPN2",maptabp, IntTab(2), 2, 2, 1, 4, 1, 1 );
	new(&clusterPN[3]) soclib::caba::DspinLocalRingFastC<vci_param, 40, 33>("clusterPN3",maptabp, IntTab(3), 2, 2, 1, 4, 1, 1 );

	// Distributed Global Interconnect : one cmd router & one rsp router per cluster
	VirtualDspinRouter<cmd_width>* cmdrouter = (VirtualDspinRouter<cmd_width>*)
	    malloc(sizeof(VirtualDspinRouter<cmd_width>) * X_MAX * Y_MAX);
	VirtualDspinRouter<rsp_width>* rsprouter = (VirtualDspinRouter<rsp_width>*)
	    malloc(sizeof(VirtualDspinRouter<rsp_width>) * X_MAX * Y_MAX);

	for ( size_t x = 0 ; x < X_MAX ; x++ )
	{
	    for ( size_t y = 0 ; y < Y_MAX ; y++ )
	    {
	
	        std::ostringstream   str_cmd;
		std::ostringstream   str_rsp;

	        str_cmd << "cmdrouter_" << x << "_" << y;
	        str_rsp << "rsprouter_" << x << "_" << y;

	        new(&cmdrouter[cluster(x,y)]) VirtualDspinRouter<cmd_width>(str_cmd.str().c_str(),
	                                                 x,y,		// coordinate in the mesh
	                                                 X_WIDTH, Y_WIDTH,	// x & y fields width
	                                                 4,4);		// input & output fifo depths
	        new(&rsprouter[cluster(x,y)]) VirtualDspinRouter<rsp_width>(str_rsp.str().c_str(),
	                                                 x,y,		// coordinates in mesh
	                                                 X_WIDTH, Y_WIDTH,	// x & y fields width
	                                                 4,4);		// input & output fifo depths
	    }
	}

	// Initiators
	initp0.p_clk(signal_clk);  
	initp0.p_resetn(signal_resetn);  
	initp0.p_cmd_out(dspin_cmd[0][0]);
	initp0.p_rsp_in(dspin_rsp[0][0]);

	initp1.p_clk(signal_clk);  
	initp1.p_resetn(signal_resetn);  
	initp1.p_cmd_out(dspin_cmd[1][0]);
	initp1.p_rsp_in(dspin_rsp[1][0]);

	initp2.p_clk(signal_clk);  
	initp2.p_resetn(signal_resetn);  
	initp2.p_cmd_out(dspin_cmd[2][0]);
	initp2.p_rsp_in(dspin_rsp[2][0]);

	initp3.p_clk(signal_clk);  
	initp3.p_resetn(signal_resetn);  
	initp3.p_cmd_out(dspin_cmd[3][0]);
	initp3.p_rsp_in(dspin_rsp[3][0]);

       // Target
	target0_0.p_clk(signal_clk);
	target0_0.p_resetn(signal_resetn);
	target0_0.p_cmd_in(dspin_cmd[0][1]);
	target0_0.p_rsp_out(dspin_rsp[0][1]);

	target0_1.p_clk(signal_clk);
	target0_1.p_resetn(signal_resetn);
	target0_1.p_cmd_in(dspin_cmd[0][2]);
	target0_1.p_rsp_out(dspin_rsp[0][2]);

	target0_2.p_clk(signal_clk);
	target0_2.p_resetn(signal_resetn);
	target0_2.p_cmd_in(dspin_cmd[0][3]);
	target0_2.p_rsp_out(dspin_rsp[0][3]);

	target0_3.p_clk(signal_clk);
	target0_3.p_resetn(signal_resetn);
	target0_3.p_cmd_in(dspin_cmd[0][4]);
	target0_3.p_rsp_out(dspin_rsp[0][4]);

	target1_0.p_clk(signal_clk);
	target1_0.p_resetn(signal_resetn);
	target1_0.p_cmd_in(dspin_cmd[1][1]);
	target1_0.p_rsp_out(dspin_rsp[1][1]);

	target1_1.p_clk(signal_clk);
	target1_1.p_resetn(signal_resetn);
	target1_1.p_cmd_in(dspin_cmd[1][2]);
	target1_1.p_rsp_out(dspin_rsp[1][2]);

	target1_2.p_clk(signal_clk);
	target1_2.p_resetn(signal_resetn);
	target1_2.p_cmd_in(dspin_cmd[1][3]);
	target1_2.p_rsp_out(dspin_rsp[1][3]);

	target1_3.p_clk(signal_clk);
	target1_3.p_resetn(signal_resetn);
	target1_3.p_cmd_in(dspin_cmd[1][4]);
	target1_3.p_rsp_out(dspin_rsp[1][4]);

	target2_0.p_clk(signal_clk);
	target2_0.p_resetn(signal_resetn);
	target2_0.p_cmd_in(dspin_cmd[2][1]);
	target2_0.p_rsp_out(dspin_rsp[2][1]);

	target2_1.p_clk(signal_clk);
	target2_1.p_resetn(signal_resetn);
	target2_1.p_cmd_in(dspin_cmd[2][2]);
	target2_1.p_rsp_out(dspin_rsp[2][2]);

	target2_2.p_clk(signal_clk);
	target2_2.p_resetn(signal_resetn);
	target2_2.p_cmd_in(dspin_cmd[2][3]);
	target2_2.p_rsp_out(dspin_rsp[2][3]);

	target2_3.p_clk(signal_clk);
	target2_3.p_resetn(signal_resetn);
	target2_3.p_cmd_in(dspin_cmd[2][4]);
	target2_3.p_rsp_out(dspin_rsp[2][4]);

	target3_0.p_clk(signal_clk);
	target3_0.p_resetn(signal_resetn);
	target3_0.p_cmd_in(dspin_cmd[3][1]);
	target3_0.p_rsp_out(dspin_rsp[3][1]);

	target3_1.p_clk(signal_clk);
	target3_1.p_resetn(signal_resetn);
	target3_1.p_cmd_in(dspin_cmd[3][2]);
	target3_1.p_rsp_out(dspin_rsp[3][2]);

	target3_2.p_clk(signal_clk);
	target3_2.p_resetn(signal_resetn);
	target3_2.p_cmd_in(dspin_cmd[3][3]);
	target3_2.p_rsp_out(dspin_rsp[3][3]);

	target3_3.p_clk(signal_clk);
	target3_3.p_resetn(signal_resetn);
	target3_3.p_cmd_in(dspin_cmd[3][4]);
	target3_3.p_rsp_out(dspin_rsp[3][4]);


	///////////////////////////////////////////////////////
	// Routers connections
	///////////////////////////////////////////////////////
	for ( size_t x = 0 ; x < X_MAX ; x++ )
	{
	    for ( size_t y = 0 ; y < Y_MAX ; y++ )
	    {
	        // cmd DSPIN router
	        cmdrouter[cluster(x,y)].p_clk			(signal_clk);
	        cmdrouter[cluster(x,y)].p_resetn		(signal_resetn);
	        cmdrouter[cluster(x,y)].p_out[0][LOCAL]		(signal_dspin_cmd_g2l_d[x][y]);
	        cmdrouter[cluster(x,y)].p_out[1][LOCAL]		(signal_dspin_cmd_g2l_c[x][y]);
	        cmdrouter[cluster(x,y)].p_in[0][LOCAL]		(signal_dspin_cmd_l2g_d[x][y]);
	        cmdrouter[cluster(x,y)].p_in[1][LOCAL]		(signal_dspin_cmd_l2g_c[x][y]);
	
	        // rsp DSPIN router
	        rsprouter[cluster(x,y)].p_clk			(signal_clk);
	        rsprouter[cluster(x,y)].p_resetn		(signal_resetn);
	        rsprouter[cluster(x,y)].p_out[0][LOCAL]		(signal_dspin_rsp_g2l_d[x][y]);
	        rsprouter[cluster(x,y)].p_out[1][LOCAL]		(signal_dspin_rsp_g2l_c[x][y]);
	        rsprouter[cluster(x,y)].p_in[0][LOCAL]		(signal_dspin_rsp_l2g_d[x][y]);
	        rsprouter[cluster(x,y)].p_in[1][LOCAL]		(signal_dspin_rsp_l2g_c[x][y]);
	    }
	}

	// Inter Clusters horizontal connections
	for ( size_t x = 0 ; x < (X_MAX-1) ; x++ )
	{
	    for ( size_t y = 0 ; y < Y_MAX ; y++ )
	    {
	        for ( size_t k = 0 ; k < 2 ; k++ )
	        {
	            cmdrouter[cluster(x,y)].p_out[k][EAST]		(signal_dspin_h_cmd_inc[x][y][k]);		
	            cmdrouter[cluster((x+1),y)].p_in[k][WEST]	(signal_dspin_h_cmd_inc[x][y][k]);
	
	            cmdrouter[cluster(x,y)].p_in[k][EAST]		(signal_dspin_h_cmd_dec[x][y][k]);		
	            cmdrouter[cluster((x+1),y)].p_out[k][WEST]	(signal_dspin_h_cmd_dec[x][y][k]);
	
	            rsprouter[cluster(x,y)].p_out[k][EAST]		(signal_dspin_h_rsp_inc[x][y][k]);		
	            rsprouter[cluster((x+1),y)].p_in[k][WEST]	(signal_dspin_h_rsp_inc[x][y][k]);
	
	            rsprouter[cluster(x,y)].p_in[k][EAST]		(signal_dspin_h_rsp_dec[x][y][k]);		
	            rsprouter[cluster((x+1),y)].p_out[k][WEST]	(signal_dspin_h_rsp_dec[x][y][k]);
	       } 
	    }
	}
	
	
	// East & West boundary clusters connections
	for ( size_t y = 0 ; y < Y_MAX ; y++ )
	{
	    for ( size_t k = 0 ; k < 2 ; k++ )
	    {
	            cmdrouter[cluster(0,y)].p_in[k][WEST]           (signal_dspin_false_cmd_in[cluster(0,y)][k][0]);
	            cmdrouter[cluster(0,y)].p_out[k][WEST]          (signal_dspin_false_cmd_out[cluster(0,y)][k][0]);
	            rsprouter[cluster(0,y)].p_in[k][WEST]           (signal_dspin_false_rsp_in[cluster(0,y)][k][0]);
	            rsprouter[cluster(0,y)].p_out[k][WEST]          (signal_dspin_false_rsp_out[cluster(0,y)][k][0]);
	
	            cmdrouter[cluster((X_MAX-1),y)].p_in[k][EAST]     (signal_dspin_false_cmd_in[cluster((X_MAX-1),y)][k][0]);
	            cmdrouter[cluster((X_MAX-1),y)].p_out[k][EAST]    (signal_dspin_false_cmd_out[cluster((X_MAX-1),y)][k][0]);
	            rsprouter[cluster((X_MAX-1),y)].p_in[k][EAST]     (signal_dspin_false_rsp_in[cluster((X_MAX-1),y)][k][0]);
	            rsprouter[cluster((X_MAX-1),y)].p_out[k][EAST]    (signal_dspin_false_rsp_out[cluster((X_MAX-1),y)][k][0]);
	    }
	 }
	
	// Inter Clusters vertical connections
	for ( size_t y = 0 ; y < (Y_MAX-1) ; y++ )
	{
	    for ( size_t x = 0 ; x < X_MAX ; x++ )
	    {
	        for ( size_t k = 0 ; k < 2 ; k++ )
	        {
	            cmdrouter[cluster(x,y)].p_out[k][NORTH]		(signal_dspin_v_cmd_inc[x][y][k]);		
	            cmdrouter[cluster(x,(y+1))].p_in[k][SOUTH]	(signal_dspin_v_cmd_inc[x][y][k]);
	
	            cmdrouter[cluster(x,y)].p_in[k][NORTH]		(signal_dspin_v_cmd_dec[x][y][k]);		
	            cmdrouter[cluster(x,(y+1))].p_out[k][SOUTH]	(signal_dspin_v_cmd_dec[x][y][k]);
	
	            rsprouter[cluster(x,y)].p_out[k][NORTH]		(signal_dspin_v_rsp_inc[x][y][k]);		
	            rsprouter[cluster(x,(y+1))].p_in[k][SOUTH]	(signal_dspin_v_rsp_inc[x][y][k]);
	
	            rsprouter[cluster(x,y)].p_in[k][NORTH]		(signal_dspin_v_rsp_dec[x][y][k]);		
	            rsprouter[cluster(x,(y+1))].p_out[k][SOUTH]	(signal_dspin_v_rsp_dec[x][y][k]);
	        }
	    }
	}
	
	// North & South boundary clusters connections
	for ( size_t x = 0 ; x < X_MAX ; x++ )
	{
	    for ( size_t k = 0 ; k < 2 ; k++ )
	    {
	            cmdrouter[cluster(x,0)].p_in[k][SOUTH]          (signal_dspin_false_cmd_in[cluster(x,0)][k][1]);
	            cmdrouter[cluster(x,0)].p_out[k][SOUTH]         (signal_dspin_false_cmd_out[cluster(x,0)][k][1]);
	            rsprouter[cluster(x,0)].p_in[k][SOUTH]          (signal_dspin_false_rsp_in[cluster(x,0)][k][1]);
	            rsprouter[cluster(x,0)].p_out[k][SOUTH]         (signal_dspin_false_rsp_out[cluster(x,0)][k][1]);
	
	            cmdrouter[cluster(x,(Y_MAX-1))].p_out[k][NORTH]   (signal_dspin_false_cmd_out[cluster(x,(Y_MAX-1))][k][1]);
         	    cmdrouter[cluster(x,(Y_MAX-1))].p_in[k][NORTH]    (signal_dspin_false_cmd_in[cluster(x,(Y_MAX-1))][k][1]);
	            rsprouter[cluster(x,(Y_MAX-1))].p_out[k][NORTH]   (signal_dspin_false_rsp_out[cluster(x,(Y_MAX-1))][k][1]);
	            rsprouter[cluster(x,(Y_MAX-1))].p_in[k][NORTH]    (signal_dspin_false_rsp_in[cluster(x,(Y_MAX-1))][k][1]);
	    }
	}

   	clusterPN[0].p_clk(signal_clk);
	clusterPN[0].p_resetn(signal_resetn);

        clusterPN[0].p_cmd_in[0](dspin_cmd[0][0]);
	clusterPN[0].p_rsp_out[0](dspin_rsp[0][0]);
 

    	clusterPN[0].p_cmd_out[0](dspin_cmd[0][1]);
	clusterPN[0].p_rsp_in[0](dspin_rsp[0][1]);
        clusterPN[0].p_cmd_out[1](dspin_cmd[0][2]);
	clusterPN[0].p_rsp_in[1](dspin_rsp[0][2]);
        clusterPN[0].p_cmd_out[2](dspin_cmd[0][3]);
	clusterPN[0].p_rsp_in[2](dspin_rsp[0][3]);
        clusterPN[0].p_cmd_out[3](dspin_cmd[0][4]);
	clusterPN[0].p_rsp_in[3](dspin_rsp[0][4]);

        clusterPN[0].p_cmd_in[1](signal_dspin_cmd_g2l_d[0][0]);
	clusterPN[0].p_rsp_out[1](signal_dspin_rsp_l2g_d[0][0]);
        clusterPN[0].p_cmd_out[4](signal_dspin_cmd_l2g_d[0][0]);
	clusterPN[0].p_rsp_in[4](signal_dspin_rsp_g2l_d[0][0]);

   	clusterPN[1].p_clk(signal_clk);
	clusterPN[1].p_resetn(signal_resetn);

        clusterPN[1].p_cmd_in[0](dspin_cmd[1][0]);
	clusterPN[1].p_rsp_out[0](dspin_rsp[1][0]);

    	clusterPN[1].p_cmd_out[0](dspin_cmd[1][1]);
	clusterPN[1].p_rsp_in[0](dspin_rsp[1][1]);
        clusterPN[1].p_cmd_out[1](dspin_cmd[1][2]);
	clusterPN[1].p_rsp_in[1](dspin_rsp[1][2]);
        clusterPN[1].p_cmd_out[2](dspin_cmd[1][3]);
	clusterPN[1].p_rsp_in[2](dspin_rsp[1][3]);
        clusterPN[1].p_cmd_out[3](dspin_cmd[1][4]);
	clusterPN[1].p_rsp_in[3](dspin_rsp[1][4]);

        clusterPN[1].p_cmd_in[1](signal_dspin_cmd_g2l_d[0][1]);
	clusterPN[1].p_rsp_out[1](signal_dspin_rsp_l2g_d[0][1]);
        clusterPN[1].p_cmd_out[4](signal_dspin_cmd_l2g_d[0][1]);
	clusterPN[1].p_rsp_in[4](signal_dspin_rsp_g2l_d[0][1]);

   	clusterPN[2].p_clk(signal_clk);
	clusterPN[2].p_resetn(signal_resetn);

        clusterPN[2].p_cmd_in[0](dspin_cmd[2][0]);
	clusterPN[2].p_rsp_out[0](dspin_rsp[2][0]);

   	clusterPN[2].p_cmd_out[0](dspin_cmd[2][1]);
	clusterPN[2].p_rsp_in[0](dspin_rsp[2][1]);
        clusterPN[2].p_cmd_out[1](dspin_cmd[2][2]);
	clusterPN[2].p_rsp_in[1](dspin_rsp[2][2]);
        clusterPN[2].p_cmd_out[2](dspin_cmd[2][3]);
	clusterPN[2].p_rsp_in[2](dspin_rsp[2][3]);
        clusterPN[2].p_cmd_out[3](dspin_cmd[2][4]);
	clusterPN[2].p_rsp_in[3](dspin_rsp[2][4]);

        clusterPN[2].p_cmd_in[1](signal_dspin_cmd_g2l_d[1][0]);
	clusterPN[2].p_rsp_out[1](signal_dspin_rsp_l2g_d[1][0]);
        clusterPN[2].p_cmd_out[4](signal_dspin_cmd_l2g_d[1][0]);
	clusterPN[2].p_rsp_in[4](signal_dspin_rsp_g2l_d[1][0]);

   	clusterPN[3].p_clk(signal_clk);
	clusterPN[3].p_resetn(signal_resetn);

        clusterPN[3].p_cmd_in[0](dspin_cmd[3][0]);
	clusterPN[3].p_rsp_out[0](dspin_rsp[3][0]);

   	clusterPN[3].p_cmd_out[0](dspin_cmd[3][1]);
	clusterPN[3].p_rsp_in[0](dspin_rsp[3][1]);
        clusterPN[3].p_cmd_out[1](dspin_cmd[3][2]);
	clusterPN[3].p_rsp_in[1](dspin_rsp[3][2]);
        clusterPN[3].p_cmd_out[2](dspin_cmd[3][3]);
	clusterPN[3].p_rsp_in[2](dspin_rsp[3][3]);
        clusterPN[3].p_cmd_out[3](dspin_cmd[3][4]);
	clusterPN[3].p_rsp_in[3](dspin_rsp[3][4]);

        clusterPN[3].p_cmd_in[1](signal_dspin_cmd_g2l_d[1][1]);
	clusterPN[3].p_rsp_out[1](signal_dspin_rsp_l2g_d[1][1]);
        clusterPN[3].p_cmd_out[4](signal_dspin_cmd_l2g_d[1][1]);
	clusterPN[3].p_rsp_in[4](signal_dspin_rsp_g2l_d[1][1]);

////////////////////////////////////////////////////////

	int ncycles;

	sc_start(sc_core::sc_time(0, SC_NS));
	signal_resetn = false;

	for(size_t x = 0; x < X_MAX; x++)
	{
		for(size_t y = 0; y < Y_MAX; y++)
		{
			signal_dspin_cmd_g2l_c[x][y].write = false;
			signal_dspin_cmd_g2l_c[x][y].read  = true;
			signal_dspin_rsp_g2l_c[x][y].write = false;
			signal_dspin_rsp_g2l_c[x][y].read  = true;
			signal_dspin_cmd_l2g_c[x][y].write = false;
			signal_dspin_cmd_l2g_c[x][y].read  = true;
			signal_dspin_rsp_l2g_c[x][y].write = false;
			signal_dspin_rsp_l2g_c[x][y].read  = true;
		}
	}

	for(size_t t = 0; t < X_MAX*Y_MAX; t++)
	{
	    for (size_t k = 0; k < 2; k++)
	    {
	        for(size_t a = 0; a < 2; a ++)
	        {
			signal_dspin_false_cmd_in[t][k][a].write = false;
			signal_dspin_false_cmd_in[t][k][a].read = true;
			signal_dspin_false_cmd_out[t][k][a].write = false;
			signal_dspin_false_cmd_out[t][k][a].read = true;
	
			signal_dspin_false_rsp_in[t][k][a].write = false;
			signal_dspin_false_rsp_in[t][k][a].read = true;
			signal_dspin_false_rsp_out[t][k][a].write = false;
			signal_dspin_false_rsp_out[t][k][a].read = true;
	       }
	    }
	}

	sc_start(sc_core::sc_time(1, SC_NS));
	signal_resetn = true;


	while(1)
	{
		//rsprouter[3].debug_trace(0);
		//rsprouter[2].debug_trace(0);
	  sc_start(sc_core::sc_time(CYCLES, SC_NS));
	  //sc_start(sc_core::sc_time(1, SC_NS));

        }

        std::cout << "Hit ENTER to end simulation" << std::endl;
        char buf[1];

	std::cin.getline(buf,1);

	return EXIT_SUCCESS;
}

int sc_main (int argc, char *argv[])
{
	try {
		return _main(argc, argv);
	} catch (std::exception &e) {
		std::cout << e.what() << std::endl;
	} catch (...) {
		std::cout << "Unknown exception occured" << std::endl;
		throw;
	}
	return 1;
}
